/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.onboarding.tests;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.webdav.xml.AbstractWebdavXMLTest;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import xmlwise.Plist;
import xmlwise.XmlParseException;

public class PListDownloadTestHelper
extends AbstractWebdavXMLTest {
    private static final String[] PLIST_BASIC_KEYS = new String[]{"PayloadIdentifier", "PayloadType", "PayloadUUID", "PayloadVersion", "PayloadDisplayName", "PayloadContent"};
    private static final String[] PLIST_MAIL_KEYS = new String[]{"PayloadType", "PayloadUUID", "PayloadIdentifier", "PayloadVersion", "EmailAccountDescription", "EmailAccountName", "EmailAccountType", "EmailAddress", "IncomingMailServerAuthentication", "IncomingMailServerHostName", "IncomingMailServerPortNumber", "IncomingMailServerUseSSL", "IncomingMailServerUsername", "OutgoingMailServerAuthentication", "OutgoingMailServerHostName", "OutgoingMailServerPortNumber", "OutgoingMailServerUseSSL", "OutgoingMailServerUsername"};
    private static final String[] PLIST_EAS_KEYS = new String[]{"PayloadType", "PayloadUUID", "PayloadIdentifier", "PayloadVersion", "UserName", "EmailAddress", "Host", "SSL"};
    private static final String[] PLIST_DAV_KEYS = new String[]{"PayloadType", "PayloadUUID", "PayloadIdentifier", "PayloadVersion", "PayloadOrganization", "CalDAVUsername", "CalDAVHostName", "CalDAVUseSSL", "CalDAVAccountDescription"};

    public PListDownloadTestHelper(String name) {
        super(name);
    }

    protected void testMailDownload(String url, String host) throws IOException, SAXException, ParserConfigurationException, TransformerException, XmlParseException {
        Map<String, Object> properties = this.testDownload(host, url);
        for (String key : PLIST_MAIL_KEYS) {
            PListDownloadTestHelper.assertTrue((boolean)properties.keySet().contains(key));
        }
        for (Object o : properties.values()) {
            PListDownloadTestHelper.assertNotNull((Object)o);
        }
    }

    protected void testEASDownload(String url, String host) throws IOException, SAXException, ParserConfigurationException, TransformerException, XmlParseException {
        Map<String, Object> properties = this.testDownload(host, url);
        for (String key : PLIST_EAS_KEYS) {
            PListDownloadTestHelper.assertTrue((boolean)properties.keySet().contains(key));
        }
        for (Object o : properties.values()) {
            PListDownloadTestHelper.assertNotNull((Object)o);
        }
    }

    protected void testDavDownload(String url, String host) throws IOException, SAXException, ParserConfigurationException, TransformerException, XmlParseException {
        Map<String, Object> properties = this.testDownload(host, url);
        for (String key : PLIST_DAV_KEYS) {
            PListDownloadTestHelper.assertTrue((boolean)properties.keySet().contains(key));
        }
        for (Object o : properties.values()) {
            PListDownloadTestHelper.assertNotNull((Object)o);
        }
    }

    private Map<String, Object> testDownload(String host, String url) throws TransformerException, XmlParseException, ParserConfigurationException, SAXException, IOException {
        host = AbstractWebdavXMLTest.appendPrefix(host);
        GetMethodWebRequest webRequest = new GetMethodWebRequest(host + url);
        WebResponse webResponse = this.getNewWebConversation().getResponse((WebRequest)webRequest);
        PListDownloadTestHelper.assertEquals((int)200, (int)webResponse.getResponseCode());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(webResponse.getInputStream());
        PListDownloadTestHelper.assertNotNull((Object)doc);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new DOMSource(doc), new StreamResult(writer));
        String plist = writer.getBuffer().toString().replaceAll("\n|\r", "");
        Map properties = Plist.fromXml((String)plist);
        PListDownloadTestHelper.assertNotNull((Object)properties);
        for (String key : PLIST_BASIC_KEYS) {
            PListDownloadTestHelper.assertTrue((boolean)properties.keySet().contains(key));
        }
        for (Object o : properties.values()) {
            PListDownloadTestHelper.assertNotNull(o);
        }
        properties = (Map)((ArrayList)properties.get("PayloadContent")).get(0);
        PListDownloadTestHelper.assertNotNull((Object)properties);
        return properties;
    }
}

