/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.ajax.oauth.provider.protocol.AbstractResponse;
import com.openexchange.ajax.oauth.provider.protocol.GETRequest;
import com.openexchange.ajax.oauth.provider.protocol.GETResponse;
import com.openexchange.ajax.oauth.provider.protocol.HttpTools;
import com.openexchange.ajax.oauth.provider.protocol.POSTRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.junit.Assert;

public final class POSTResponse
extends AbstractResponse {
    private final URI redirectLocation;
    private final POSTRequest request;

    POSTResponse(POSTRequest request, HttpResponse response) throws IOException {
        super(response);
        this.request = request;
        String location = this.getHeader("Location");
        this.redirectLocation = location == null ? null : URI.create(location);
    }

    public URI getRedirectLocation() {
        return this.redirectLocation;
    }

    public void assertRedirect() {
        this.assertStatus(302);
        Assert.assertNotNull((String)"Location header was missing in response", (Object)this.redirectLocation);
    }

    public GETResponse followRedirect(HttpClient client) throws IOException {
        this.assertRedirect();
        try {
            URI location = this.getRedirectLocation();
            Map<String, String> params = HttpTools.extractQueryParams(location);
            GETRequest getRequest = (GETRequest)((GETRequest)new GETRequest().setScheme(location.getScheme())).setHostname(location.getHost());
            for (String param : params.keySet()) {
                getRequest.setParameter(param, params.get(param));
            }
            return getRequest.execute(client);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

