/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.ajax.oauth.provider.protocol.AbstractRequest;
import com.openexchange.ajax.oauth.provider.protocol.GETRequest;
import com.openexchange.ajax.oauth.provider.protocol.POSTResponse;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;

public class POSTRequest
extends AbstractRequest<POSTRequest> {
    String sessionId;
    String login;
    String password;
    boolean accessDenied;

    public static GETRequest newGETRequest() {
        return new GETRequest();
    }

    public POSTRequest setLogin(String login) {
        this.login = login;
        return this;
    }

    public POSTRequest setPassword(String password) {
        this.password = password;
        return this;
    }

    public POSTRequest setAccessDenied() {
        this.accessDenied = true;
        return this;
    }

    public POSTResponse submit(HttpClient client) throws IOException {
        HashMap<String, String> requestSpecificParams = new HashMap<String, String>(5);
        requestSpecificParams.put("access_denied", Boolean.toString(this.accessDenied));
        if (this.login != null) {
            requestSpecificParams.put("login", this.login);
        }
        if (this.password != null) {
            requestSpecificParams.put("password", this.password);
        }
        List<NameValuePair> params = this.prepareParams(requestSpecificParams);
        try {
            HttpPost request = new HttpPost(new URIBuilder().setScheme(this.scheme).setHost(this.hostname).setPath("/ajax/oauth/provider/authorization").build());
            for (String header : this.headers.keySet()) {
                String value = (String)this.headers.get(header);
                if (value == null) {
                    request.removeHeaders(header);
                    continue;
                }
                request.setHeader(header, value);
            }
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
            return new POSTResponse(this, client.execute((HttpUriRequest)request));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

