/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider.protocol;

import com.openexchange.ajax.oauth.provider.protocol.AbstractResponse;
import com.openexchange.ajax.oauth.provider.protocol.GETRequest;
import com.openexchange.ajax.oauth.provider.protocol.HttpTools;
import com.openexchange.ajax.oauth.provider.protocol.POSTRequest;
import com.openexchange.java.Charsets;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.junit.Assert;

public final class GETResponse
extends AbstractResponse {
    private final GETRequest request;

    GETResponse(GETRequest request, HttpResponse loginPageResponse) throws IOException {
        super(loginPageResponse);
        this.request = request;
    }

    public POSTRequest preparePOSTRequest() {
        this.assertOK();
        Assert.assertNotNull((Object)this.body);
        Map<String, String> hiddenFormFields = HttpTools.getHiddenFormFields(new String(this.body, Charsets.UTF_8));
        POSTRequest postRequest = (POSTRequest)new POSTRequest().setHostname(this.request.hostname);
        for (String param : hiddenFormFields.keySet()) {
            String value = hiddenFormFields.get(param);
            if (param == null || value == null) continue;
            postRequest.setParameter(param, value);
        }
        postRequest.setHeader("Referer", "https://" + this.request.hostname + "/ajax/oauth/provider/authorization");
        return postRequest;
    }
}

