/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.oauth.provider;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.oauth.provider.AbstractOAuthTest;
import com.openexchange.ajax.oauth.provider.IconBytes;
import com.openexchange.ajax.oauth.provider.OAuthClient;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.oauth.provider.rmi.client.ClientDataDto;
import com.openexchange.oauth.provider.rmi.client.ClientDto;
import com.openexchange.oauth.provider.rmi.client.IconDto;
import com.openexchange.oauth.provider.rmi.client.RemoteClientManagement;
import com.openexchange.oauth.provider.scope.Scope;
import java.io.IOException;
import java.rmi.Naming;
import java.util.ArrayList;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class EndpointTest {
    public static final String AUTHORIZATION_ENDPOINT = "/ajax/oauth/provider/authorization";
    public static final String TOKEN_ENDPOINT = "/ajax/oauth/provider/accessToken";
    public static final String REVOKE_ENDPOINT = "/ajax/oauth/provider/revoke";
    protected static String hostname;
    protected static String login;
    protected static String password;
    protected DefaultHttpClient client;
    protected ClientDto oauthClient;
    protected String csrfState;

    @BeforeClass
    public static void beforeClass() throws OXException {
        AJAXConfig.init();
        hostname = AJAXConfig.getProperty(AJAXConfig.Property.HOSTNAME);
        login = AJAXConfig.getProperty(AJAXClient.User.User1.getLogin()) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        password = AJAXConfig.getProperty(AJAXClient.User.User1.getPassword());
    }

    @Before
    public void before() throws Exception {
        this.client = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager());
        HttpParams params = this.client.getParams();
        int minute = 60000;
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)minute);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)minute);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SSLSocketFactory ssf = new SSLSocketFactory((TrustStrategy)new TrustSelfSignedStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier());
        this.client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        ClientDataDto clientData = EndpointTest.prepareClient("Test App " + System.currentTimeMillis());
        RemoteClientManagement clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        this.oauthClient = clientManagement.registerClient("default", clientData, AbstractOAuthTest.getMasterAdminCredentials());
        this.csrfState = UUIDs.getUnformattedStringFromRandom();
    }

    @After
    public void after() throws Exception {
        this.client.getConnectionManager().shutdown();
        RemoteClientManagement clientManagement = (RemoteClientManagement)Naming.lookup("rmi://" + AJAXConfig.getProperty(AJAXConfig.Property.RMI_HOST) + ":1099/" + RemoteClientManagement.RMI_NAME);
        clientManagement.unregisterClient(this.oauthClient.getId(), AbstractOAuthTest.getMasterAdminCredentials());
    }

    protected void expectSecureRedirect(HttpUriRequest request, HttpResponse response) {
        Assert.assertEquals((long)301L, (long)response.getStatusLine().getStatusCode());
        Header location = response.getFirstHeader("Location");
        Assert.assertNotNull((Object)location);
        Assert.assertEquals((Object)("https://" + request.getURI().toString().substring(7)), (Object)location.getValue());
    }

    protected HttpResponse executeAndConsume(HttpRequestBase request) throws ClientProtocolException, IOException {
        HttpResponse response = this.client.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        return response;
    }

    protected Scope getScope() {
        return Scope.parseScope((String)this.oauthClient.getDefaultScope());
    }

    protected String getClientId() {
        return this.oauthClient.getId();
    }

    protected String getClientSecret() {
        return this.oauthClient.getSecret();
    }

    protected String getRedirectURI() {
        return (String)this.oauthClient.getRedirectURIs().get(0);
    }

    protected String getSecondRedirectURI() {
        return (String)this.oauthClient.getRedirectURIs().get(1);
    }

    protected static ClientDataDto prepareClient(String name) {
        IconDto icon = new IconDto();
        icon.setData(IconBytes.DATA);
        icon.setMimeType("image/jpg");
        ArrayList<String> redirectURIs = new ArrayList<String>(2);
        redirectURIs.add("http://localhost");
        redirectURIs.add("http://localhost:8080");
        ClientDataDto clientData = new ClientDataDto();
        clientData.setName(name);
        clientData.setDescription(name);
        clientData.setIcon(icon);
        clientData.setContactAddress("webmaster@example.com");
        clientData.setWebsite("http://www.example.com");
        clientData.setDefaultScope("read_contacts");
        clientData.setRedirectURIs(redirectURIs);
        return clientData;
    }

    protected static void assertNoAccess(OAuthClient client) throws Exception {
        boolean error = false;
        try {
            client.assertAccess();
        }
        catch (AssertionError e) {
            error = true;
        }
        Assert.assertTrue((String)"API access was possible although it should not", (boolean)error);
    }
}

