/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.CookieListener;
import com.meterware.httpunit.cookies.CookieProperties;
import com.openexchange.ajax.mail.filter.AJAXTest;
import java.io.IOException;
import java.net.MalformedURLException;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.xml.sax.SAXException;

public class GroupwareTests
extends AJAXTest {
    private static final String AUTHPASSWORD = "secret";
    private static final String AUTHNAME = "olox20@premium";
    private static final String HOSTNAME = "localhost";
    private static final String LOGIN_URL = "/ajax/login";

    @Override
    public AJAXTest.WebconversationAndSessionID login() throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        HttpUnitOptions.setDefaultCharacterSet((String)"UTF-8");
        HttpUnitOptions.setScriptingEnabled((boolean)false);
        CookieProperties.setPathMatchingStrict((boolean)false);
        CookieProperties.addCookieListener((CookieListener)new CookieListener(){

            public void cookieRejected(String cookieName, int reason, String attribute) {
                System.out.println("Cookie: " + cookieName + " was rejected due to " + reason + " ; attribute " + attribute);
            }
        });
        WebConversation conversation = new WebConversation();
        String login = AUTHNAME;
        String password = AUTHPASSWORD;
        System.out.println("Logging in.");
        PostMethodWebRequest req = new PostMethodWebRequest("http://" + this.getHostname() + LOGIN_URL);
        req.setParameter("action", "login");
        req.setParameter("name", AUTHNAME);
        req.setParameter("password", AUTHPASSWORD);
        WebResponse resp = conversation.getResponse((WebRequest)req);
        System.out.println(resp);
        for (String cookie : resp.getNewCookieNames()) {
            System.out.println("Found new cookie: " + cookie);
        }
        for (String cookie : conversation.getCookieNames()) {
            System.out.println("Found Cookie: " + cookie);
        }
        System.out.println("Session:" + conversation.getCookieValue("JSESSIONID"));
        Assert.assertEquals((String)"Response code is not okay.", (long)200L, (long)resp.getResponseCode());
        String body = resp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)json.optString("error"), (boolean)json.has("error"));
        Assert.assertTrue((String)("Session ID is missing: " + body), (boolean)json.has("session"));
        System.out.println(json);
        return new AJAXTest.WebconversationAndSessionID(conversation, (String)json.get("session"));
    }

    @Override
    protected String getHostname() {
        return HOSTNAME;
    }

    @Override
    protected String getUsername() {
        return null;
    }
}

