/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.java.Charsets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

public abstract class AJAXTest {
    public static final String PROTOCOL = "http://";
    private static final String MAILFILTER_URL = "/ajax/mailfilter";
    private static final String LOGOUT_URL = "/ajax/login";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterconfigTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterconfig(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterlistTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterlist(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterdeleteTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"default.INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"default.INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterVacationTestWithOutSubject() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject base = new JSONObject();
            base.put("rulename", (Object)"Abwesenheitsbenachrichtigung");
            base.put("active", (Object)Boolean.TRUE);
            base.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"true");
            base.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"dennis.sieben@open-xchange.com");
            action.put("text", (Object)"I'm out of office");
            base.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), base.toString(), null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationPlainAtTheEndTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationPlainInBetweenTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"text\":\"if true \\r\\n{\\r\\n    vacation :days 13 :addresses [ \\\"root@localhost\\\" , \\\"billg@microsoft.com\\\" ] :mime :subject \\\"Betreff\\\" \\\"Text\\r\\nText\\\" ;\\r\\n}\\r\\n\",\"errormsg\":\"\",\"flags\":[\"vacation\"],\"id\":3,\"rulename\":\"Vacation Notice\"}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewPGPTestZero() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Inbox encryption\",\"active\":false,\"flags\":[],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[]}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Inbox encryption\",\"active\":false,\"flags\":[],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[]}]}", "Empty string-arrays are not allowed in sieve.");
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewPGPTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"PGP\",\"active\":true,\"flags\":[\"\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLreFoBCADOWZYrs/btv3DExwazPTxkmkzdmKgp3uw3+w0UDohFyyOcXowv\\u000a81Q7DGEuTU9lk/R1TigzBWfVt8OOAKGGn1JGcDs+CVGdU++4VUoT9KvwoPL7K8Ys\\u000afrxWGxheEP4XGEhN++92dsQ1p6hIeZPf5z3V3MofZRls+SDeo1zhi33DGiYVYQHp\\u000aD3A6+8X9rITsdRUXeyT6Qrv8q4yr6hUf2BnX5B+HSLjJeQ7CPj1YCM01onZIwSlv\\u000ag4hpEx/JmHSupMkmCk7FpXXCM+fvdq07PtQBAd1Cbw4IPhdvQYop+tYID/ChBC4K\\u000atv1dU+UBvSausx4GjmkLgcGooYSvHR5YZrnzABEBAAG0MkhhYmkgVGFrICh0ZXN0\\u000aYWNjb3VudCkgPGhhYml0YWtAdGVzdC5mYWlsbWFpbC5vcmc+iQE+BBMBAgAoBQJS\\u000a63haAhsDBQkB4TOABgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAdGOi2gcHA\\u000aQgk+B/9Td7mc2i0NEa367LG6LQCq5EqdGWv9F3GeGZ+5eA/j058IwIedamLgpgh8\\u000ax3DyHhv9cPtPEWN9ZNlxIwRMv8JhS08PgXScOfbyaOktF03W7a7Qq190nVUKfMfo\\u000a4wPewKGNSpXqLn1wNiAaeSIftShylShTw+1nMKjyYBmWxRWcuta5wNLC4nJ1XcVb\\u000a3kSkXvH9GGCTd6iiZ6who12XmjmRXmSkCpIgG57hwykeQJ1gqVoeOXYC2xJA3EsJ\\u000a9m3o/ElVqsyUs7rzROeXImOYadIRwerVtcchsyPMCZJrJXwDan0dZykcwfgydMbA\\u000aX+GSrdiYPqSl8xJp4l4mibQUlvxYuQENBFLreFoBCADHqj2Xgi1tiyO5qcLvh7LF\\u000aqoA8Zfa9YNL8QyaZfEGWCY3inZ1BuvbjRw4P8B0deOoKkOxgc3BLaPOL3TMQIv2j\\u000awYuWXqLnn6zfC1eAlql4Ms+yMIm8nZ5y6Dua23bUeUpp/wd6+ZBD+jd7cVatsT9O\\u000aCOje4xiw3R7vAofz9iQl6WI5/7ILi5IGPJ/KtlLtDeufLG9loRNHyT5pRJqIXiMG\\u000ap3kfe5YGuNPpktSLPKUZeZOmIQG3wBRAD21qjI0H93aG9M6KbaU4veiyBz6Pd+IA\\u000aSzOMrOGc/usnAb7Ze8Xlm6ulQh/Zby3GiivzldQeJxuj2f9mo+1GdQPMzZhVk6tT\\u000aABEBAAGJASUEGAECAA8FAlLreFoCGwwFCQHhM4AACgkQHRjotoHBwEJ6iQf+NqIK\\u000aO2VhNZdZFPO6sX9ENeW0skZz3x6iqJ+d7xxhmdNRNFihDcaXPc0CKSzjV2jq5xHP\\u000aLcbqcPwLJZAIeXAOQyUQ0PAxdmJbPws8wg+evb3fQa9NpBbUnsQpBUrBvMhPidgH\\u000abKviYr9eU1u2XwF+YLx21KFJmHcBfZARbkg8bxweRIlF9K4WKEhA6bi62F/NNxFU\\u000aD8vG92Pach9vxJmPTY6Afv2YQQzcE1ZFxsw4ilImLYd0l28GWyHHEmHJaC4RZWXg\\u000a5HMSS3/MzcRwJMAOjloFzkAtM1NdqSIhXR9A+UWOqRrN9YsaZ0toygJ6+s4CuC5E\\u000axIkAf8c60CqC9IpP4Q==\\u000a=lIKb\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\"]}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"PGP\",\"active\":true,\"flags\":[\"\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLreFoBCADOWZYrs/btv3DExwazPTxkmkzdmKgp3uw3+w0UDohFyyOcXowv\\u000a81Q7DGEuTU9lk/R1TigzBWfVt8OOAKGGn1JGcDs+CVGdU++4VUoT9KvwoPL7K8Ys\\u000afrxWGxheEP4XGEhN++92dsQ1p6hIeZPf5z3V3MofZRls+SDeo1zhi33DGiYVYQHp\\u000aD3A6+8X9rITsdRUXeyT6Qrv8q4yr6hUf2BnX5B+HSLjJeQ7CPj1YCM01onZIwSlv\\u000ag4hpEx/JmHSupMkmCk7FpXXCM+fvdq07PtQBAd1Cbw4IPhdvQYop+tYID/ChBC4K\\u000atv1dU+UBvSausx4GjmkLgcGooYSvHR5YZrnzABEBAAG0MkhhYmkgVGFrICh0ZXN0\\u000aYWNjb3VudCkgPGhhYml0YWtAdGVzdC5mYWlsbWFpbC5vcmc+iQE+BBMBAgAoBQJS\\u000a63haAhsDBQkB4TOABgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAdGOi2gcHA\\u000aQgk+B/9Td7mc2i0NEa367LG6LQCq5EqdGWv9F3GeGZ+5eA/j058IwIedamLgpgh8\\u000ax3DyHhv9cPtPEWN9ZNlxIwRMv8JhS08PgXScOfbyaOktF03W7a7Qq190nVUKfMfo\\u000a4wPewKGNSpXqLn1wNiAaeSIftShylShTw+1nMKjyYBmWxRWcuta5wNLC4nJ1XcVb\\u000a3kSkXvH9GGCTd6iiZ6who12XmjmRXmSkCpIgG57hwykeQJ1gqVoeOXYC2xJA3EsJ\\u000a9m3o/ElVqsyUs7rzROeXImOYadIRwerVtcchsyPMCZJrJXwDan0dZykcwfgydMbA\\u000aX+GSrdiYPqSl8xJp4l4mibQUlvxYuQENBFLreFoBCADHqj2Xgi1tiyO5qcLvh7LF\\u000aqoA8Zfa9YNL8QyaZfEGWCY3inZ1BuvbjRw4P8B0deOoKkOxgc3BLaPOL3TMQIv2j\\u000awYuWXqLnn6zfC1eAlql4Ms+yMIm8nZ5y6Dua23bUeUpp/wd6+ZBD+jd7cVatsT9O\\u000aCOje4xiw3R7vAofz9iQl6WI5/7ILi5IGPJ/KtlLtDeufLG9loRNHyT5pRJqIXiMG\\u000ap3kfe5YGuNPpktSLPKUZeZOmIQG3wBRAD21qjI0H93aG9M6KbaU4veiyBz6Pd+IA\\u000aSzOMrOGc/usnAb7Ze8Xlm6ulQh/Zby3GiivzldQeJxuj2f9mo+1GdQPMzZhVk6tT\\u000aABEBAAGJASUEGAECAA8FAlLreFoCGwwFCQHhM4AACgkQHRjotoHBwEJ6iQf+NqIK\\u000aO2VhNZdZFPO6sX9ENeW0skZz3x6iqJ+d7xxhmdNRNFihDcaXPc0CKSzjV2jq5xHP\\u000aLcbqcPwLJZAIeXAOQyUQ0PAxdmJbPws8wg+evb3fQa9NpBbUnsQpBUrBvMhPidgH\\u000abKviYr9eU1u2XwF+YLx21KFJmHcBfZARbkg8bxweRIlF9K4WKEhA6bi62F/NNxFU\\u000aD8vG92Pach9vxJmPTY6Afv2YQQzcE1ZFxsw4ilImLYd0l28GWyHHEmHJaC4RZWXg\\u000a5HMSS3/MzcRwJMAOjloFzkAtM1NdqSIhXR9A+UWOqRrN9YsaZ0toygJ6+s4CuC5E\\u000axIkAf8c60CqC9IpP4Q==\\u000a=lIKb\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\"]}]}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewPGP2KeysTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"PGP\",\"active\":true,\"flags\":[\"\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLreFoBCADOWZYrs/btv3DExwazPTxkmkzdmKgp3uw3+w0UDohFyyOcXowv\\u000a81Q7DGEuTU9lk/R1TigzBWfVt8OOAKGGn1JGcDs+CVGdU++4VUoT9KvwoPL7K8Ys\\u000afrxWGxheEP4XGEhN++92dsQ1p6hIeZPf5z3V3MofZRls+SDeo1zhi33DGiYVYQHp\\u000aD3A6+8X9rITsdRUXeyT6Qrv8q4yr6hUf2BnX5B+HSLjJeQ7CPj1YCM01onZIwSlv\\u000ag4hpEx/JmHSupMkmCk7FpXXCM+fvdq07PtQBAd1Cbw4IPhdvQYop+tYID/ChBC4K\\u000atv1dU+UBvSausx4GjmkLgcGooYSvHR5YZrnzABEBAAG0MkhhYmkgVGFrICh0ZXN0\\u000aYWNjb3VudCkgPGhhYml0YWtAdGVzdC5mYWlsbWFpbC5vcmc+iQE+BBMBAgAoBQJS\\u000a63haAhsDBQkB4TOABgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAdGOi2gcHA\\u000aQgk+B/9Td7mc2i0NEa367LG6LQCq5EqdGWv9F3GeGZ+5eA/j058IwIedamLgpgh8\\u000ax3DyHhv9cPtPEWN9ZNlxIwRMv8JhS08PgXScOfbyaOktF03W7a7Qq190nVUKfMfo\\u000a4wPewKGNSpXqLn1wNiAaeSIftShylShTw+1nMKjyYBmWxRWcuta5wNLC4nJ1XcVb\\u000a3kSkXvH9GGCTd6iiZ6who12XmjmRXmSkCpIgG57hwykeQJ1gqVoeOXYC2xJA3EsJ\\u000a9m3o/ElVqsyUs7rzROeXImOYadIRwerVtcchsyPMCZJrJXwDan0dZykcwfgydMbA\\u000aX+GSrdiYPqSl8xJp4l4mibQUlvxYuQENBFLreFoBCADHqj2Xgi1tiyO5qcLvh7LF\\u000aqoA8Zfa9YNL8QyaZfEGWCY3inZ1BuvbjRw4P8B0deOoKkOxgc3BLaPOL3TMQIv2j\\u000awYuWXqLnn6zfC1eAlql4Ms+yMIm8nZ5y6Dua23bUeUpp/wd6+ZBD+jd7cVatsT9O\\u000aCOje4xiw3R7vAofz9iQl6WI5/7ILi5IGPJ/KtlLtDeufLG9loRNHyT5pRJqIXiMG\\u000ap3kfe5YGuNPpktSLPKUZeZOmIQG3wBRAD21qjI0H93aG9M6KbaU4veiyBz6Pd+IA\\u000aSzOMrOGc/usnAb7Ze8Xlm6ulQh/Zby3GiivzldQeJxuj2f9mo+1GdQPMzZhVk6tT\\u000aABEBAAGJASUEGAECAA8FAlLreFoCGwwFCQHhM4AACgkQHRjotoHBwEJ6iQf+NqIK\\u000aO2VhNZdZFPO6sX9ENeW0skZz3x6iqJ+d7xxhmdNRNFihDcaXPc0CKSzjV2jq5xHP\\u000aLcbqcPwLJZAIeXAOQyUQ0PAxdmJbPws8wg+evb3fQa9NpBbUnsQpBUrBvMhPidgH\\u000abKviYr9eU1u2XwF+YLx21KFJmHcBfZARbkg8bxweRIlF9K4WKEhA6bi62F/NNxFU\\u000aD8vG92Pach9vxJmPTY6Afv2YQQzcE1ZFxsw4ilImLYd0l28GWyHHEmHJaC4RZWXg\\u000a5HMSS3/MzcRwJMAOjloFzkAtM1NdqSIhXR9A+UWOqRrN9YsaZ0toygJ6+s4CuC5E\\u000axIkAf8c60CqC9IpP4Q==\\u000a=lIKb\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\",\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLeQMwBCADj/5cH+zw67hEkM9JmzVj2IZjy7vuwrlCvO9908qvJ29r6oZti\\u000aMbtVfZ5SZb1wxjnQhGHQqTUbSxHP916y0xKypPBf2UdkQr+yNsb6pZsvpB9gxn/N\\u000ach6TPwRD36g/XlsWxBe2V/JlYexzJELi6u/ilxjzf22oCOOjU5251hK3c9VpRfRW\\u000aLu1LSfXCGHsxZw2e32it7yb3yjpiZ/KhzuFBXNLcV/b5oosJcTx5sqn3ohLb6oHn\\u000aLmBfw+6G9xEJsYMMvKqKiRK4eHTSHihOoXVYORPFbvygFo8uYVN5904fU9qZzSgK\\u000as9IEWA135P4z46p8VatvBAWPge/pK4hT2mKJABEBAAG0K1RhdWIgT3NzICh0ZXN0\\u000aKSA8dGF1Ym9zc0B0ZXN0LmZhaWxtYWlsLm9yZz6JAT4EEwECACgFAlLeQMwCGwMF\\u000aCQHhM4AGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEA0+C0wRU/tiYYgH/R/Q\\u000aCz6ozUt3dsU7i89YrJQAQAZAMEgOToofWNIdzbK2EUjMsLZsEnuJb9r3IB7pHZ6D\\u000aX8jBwgRv9y30hF3Y3pDg1ivyL9sxI0DUKVq/ZzLEvPVZjjwKybAxffLBsU+OHDtK\\u000aQPS1zyJJp9AxR10h6sQDFgPN9hq5X03YEectyO0T7ry9v/CzTk27Iq8fhC1ciRoB\\u000ajrcXaHpdWBv0452ifz4D70CvHPxMDN8MYSoq7VQXHFm7JNK/3cCzahQzbcz7uS+U\\u000a9jbXQ4GOYdIzMmx+WjAU+6ZHL2feMMpNKmYF6ivhv2IOxSszVoQIa2Ul97Fq0CxC\\u000aRHKf/bT4GkNvFnG3hx65AQ0EUt5AzAEIAMuWswB/A1HP7nw901kpUZW15RMk5n1Q\\u000af2fHB/2u7w8XIXq+mcEJEveSXB57vTLU/piPTUctEClDFWcIt/b7hzeGU3IHy52w\\u000ab5moPG5EYLk1vTxt31e5/D3wD5j5Sc6hw9AOBZGq5S4qMDWrWtgjFLy6fvPMv8MS\\u000aqmt+E63mQfs3qXwGD8refeqP13j3o2oG7r/4o5u8DD1JLvfDJHsFtDYiE/ympXN8\\u000am3Z5CL5tOJl9Rgp4BImAbOHE0sGaOah6iRpclJVzKvBRfELfJa9xIOjZxfQLvDl/\\u000agO0/AdgAGyYGuh/II9SCO42wDQEjr1c0u9XGM2NaTuYnucYPiOHxZQMAEQEAAYkB\\u000aJQQYAQIADwUCUt5AzAIbDAUJAeEzgAAKCRANPgtMEVP7YiXMB/95E3CKZtzONNMO\\u000aRmuzDfmGRT8XKla/lYDpmmm1xKgBjyfkgGt/6/b5zq+B0bvsWYFKTiz3DJz6dQMr\\u000aG12wV+k76slIqvtqoVjgovH+F69xvKcT9+fge1ZpFaq3fqHwhIevcm2PSUw8bE9G\\u000ahBZ1O2eRcoc0+pEjhK5VQ8C/zRjfiy7VTFmx3S1v+Q1KfK8tw3UrevB4RSsg+VR2\\u000azNAsmnYoFnYM3rCBV/9muavmzo/A3/hY/vwJ2q2bNZSM3R2iIMwnp0vJ4+P0f5+F\\u000aQ6bL51I8/InAJmcApBBpcaPESV1X3GIZUcrGwfOm6ycwF1wlKrD/pqOvRiGFEoH6\\u000aYNOiosMN\\u000a=xuj5\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\"]}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"PGP\",\"active\":true,\"flags\":[\"\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"pgp\",\"keys\":[\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLreFoBCADOWZYrs/btv3DExwazPTxkmkzdmKgp3uw3+w0UDohFyyOcXowv\\u000a81Q7DGEuTU9lk/R1TigzBWfVt8OOAKGGn1JGcDs+CVGdU++4VUoT9KvwoPL7K8Ys\\u000afrxWGxheEP4XGEhN++92dsQ1p6hIeZPf5z3V3MofZRls+SDeo1zhi33DGiYVYQHp\\u000aD3A6+8X9rITsdRUXeyT6Qrv8q4yr6hUf2BnX5B+HSLjJeQ7CPj1YCM01onZIwSlv\\u000ag4hpEx/JmHSupMkmCk7FpXXCM+fvdq07PtQBAd1Cbw4IPhdvQYop+tYID/ChBC4K\\u000atv1dU+UBvSausx4GjmkLgcGooYSvHR5YZrnzABEBAAG0MkhhYmkgVGFrICh0ZXN0\\u000aYWNjb3VudCkgPGhhYml0YWtAdGVzdC5mYWlsbWFpbC5vcmc+iQE+BBMBAgAoBQJS\\u000a63haAhsDBQkB4TOABgsJCAcDAgYVCAIJCgsEFgIDAQIeAQIXgAAKCRAdGOi2gcHA\\u000aQgk+B/9Td7mc2i0NEa367LG6LQCq5EqdGWv9F3GeGZ+5eA/j058IwIedamLgpgh8\\u000ax3DyHhv9cPtPEWN9ZNlxIwRMv8JhS08PgXScOfbyaOktF03W7a7Qq190nVUKfMfo\\u000a4wPewKGNSpXqLn1wNiAaeSIftShylShTw+1nMKjyYBmWxRWcuta5wNLC4nJ1XcVb\\u000a3kSkXvH9GGCTd6iiZ6who12XmjmRXmSkCpIgG57hwykeQJ1gqVoeOXYC2xJA3EsJ\\u000a9m3o/ElVqsyUs7rzROeXImOYadIRwerVtcchsyPMCZJrJXwDan0dZykcwfgydMbA\\u000aX+GSrdiYPqSl8xJp4l4mibQUlvxYuQENBFLreFoBCADHqj2Xgi1tiyO5qcLvh7LF\\u000aqoA8Zfa9YNL8QyaZfEGWCY3inZ1BuvbjRw4P8B0deOoKkOxgc3BLaPOL3TMQIv2j\\u000awYuWXqLnn6zfC1eAlql4Ms+yMIm8nZ5y6Dua23bUeUpp/wd6+ZBD+jd7cVatsT9O\\u000aCOje4xiw3R7vAofz9iQl6WI5/7ILi5IGPJ/KtlLtDeufLG9loRNHyT5pRJqIXiMG\\u000ap3kfe5YGuNPpktSLPKUZeZOmIQG3wBRAD21qjI0H93aG9M6KbaU4veiyBz6Pd+IA\\u000aSzOMrOGc/usnAb7Ze8Xlm6ulQh/Zby3GiivzldQeJxuj2f9mo+1GdQPMzZhVk6tT\\u000aABEBAAGJASUEGAECAA8FAlLreFoCGwwFCQHhM4AACgkQHRjotoHBwEJ6iQf+NqIK\\u000aO2VhNZdZFPO6sX9ENeW0skZz3x6iqJ+d7xxhmdNRNFihDcaXPc0CKSzjV2jq5xHP\\u000aLcbqcPwLJZAIeXAOQyUQ0PAxdmJbPws8wg+evb3fQa9NpBbUnsQpBUrBvMhPidgH\\u000abKviYr9eU1u2XwF+YLx21KFJmHcBfZARbkg8bxweRIlF9K4WKEhA6bi62F/NNxFU\\u000aD8vG92Pach9vxJmPTY6Afv2YQQzcE1ZFxsw4ilImLYd0l28GWyHHEmHJaC4RZWXg\\u000a5HMSS3/MzcRwJMAOjloFzkAtM1NdqSIhXR9A+UWOqRrN9YsaZ0toygJ6+s4CuC5E\\u000axIkAf8c60CqC9IpP4Q==\\u000a=lIKb\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\",\"-----BEGIN PGP PUBLIC KEY BLOCK-----\\u000aVersion: GnuPG v2.0.17 (GNU/Linux)\\u000a\\u000amQENBFLeQMwBCADj/5cH+zw67hEkM9JmzVj2IZjy7vuwrlCvO9908qvJ29r6oZti\\u000aMbtVfZ5SZb1wxjnQhGHQqTUbSxHP916y0xKypPBf2UdkQr+yNsb6pZsvpB9gxn/N\\u000ach6TPwRD36g/XlsWxBe2V/JlYexzJELi6u/ilxjzf22oCOOjU5251hK3c9VpRfRW\\u000aLu1LSfXCGHsxZw2e32it7yb3yjpiZ/KhzuFBXNLcV/b5oosJcTx5sqn3ohLb6oHn\\u000aLmBfw+6G9xEJsYMMvKqKiRK4eHTSHihOoXVYORPFbvygFo8uYVN5904fU9qZzSgK\\u000as9IEWA135P4z46p8VatvBAWPge/pK4hT2mKJABEBAAG0K1RhdWIgT3NzICh0ZXN0\\u000aKSA8dGF1Ym9zc0B0ZXN0LmZhaWxtYWlsLm9yZz6JAT4EEwECACgFAlLeQMwCGwMF\\u000aCQHhM4AGCwkIBwMCBhUIAgkKCwQWAgMBAh4BAheAAAoJEA0+C0wRU/tiYYgH/R/Q\\u000aCz6ozUt3dsU7i89YrJQAQAZAMEgOToofWNIdzbK2EUjMsLZsEnuJb9r3IB7pHZ6D\\u000aX8jBwgRv9y30hF3Y3pDg1ivyL9sxI0DUKVq/ZzLEvPVZjjwKybAxffLBsU+OHDtK\\u000aQPS1zyJJp9AxR10h6sQDFgPN9hq5X03YEectyO0T7ry9v/CzTk27Iq8fhC1ciRoB\\u000ajrcXaHpdWBv0452ifz4D70CvHPxMDN8MYSoq7VQXHFm7JNK/3cCzahQzbcz7uS+U\\u000a9jbXQ4GOYdIzMmx+WjAU+6ZHL2feMMpNKmYF6ivhv2IOxSszVoQIa2Ul97Fq0CxC\\u000aRHKf/bT4GkNvFnG3hx65AQ0EUt5AzAEIAMuWswB/A1HP7nw901kpUZW15RMk5n1Q\\u000af2fHB/2u7w8XIXq+mcEJEveSXB57vTLU/piPTUctEClDFWcIt/b7hzeGU3IHy52w\\u000ab5moPG5EYLk1vTxt31e5/D3wD5j5Sc6hw9AOBZGq5S4qMDWrWtgjFLy6fvPMv8MS\\u000aqmt+E63mQfs3qXwGD8refeqP13j3o2oG7r/4o5u8DD1JLvfDJHsFtDYiE/ympXN8\\u000am3Z5CL5tOJl9Rgp4BImAbOHE0sGaOah6iRpclJVzKvBRfELfJa9xIOjZxfQLvDl/\\u000agO0/AdgAGyYGuh/II9SCO42wDQEjr1c0u9XGM2NaTuYnucYPiOHxZQMAEQEAAYkB\\u000aJQQYAQIADwUCUt5AzAIbDAUJAeEzgAAKCRANPgtMEVP7YiXMB/95E3CKZtzONNMO\\u000aRmuzDfmGRT8XKla/lYDpmmm1xKgBjyfkgGt/6/b5zq+B0bvsWYFKTiz3DJz6dQMr\\u000aG12wV+k76slIqvtqoVjgovH+F69xvKcT9+fge1ZpFaq3fqHwhIevcm2PSUw8bE9G\\u000ahBZ1O2eRcoc0+pEjhK5VQ8C/zRjfiy7VTFmx3S1v+Q1KfK8tw3UrevB4RSsg+VR2\\u000azNAsmnYoFnYM3rCBV/9muavmzo/A3/hY/vwJ2q2bNZSM3R2iIMwnp0vJ4+P0f5+F\\u000aQ6bL51I8/InAJmcApBBpcaPESV1X3GIZUcrGwfOm6ycwF1wlKrD/pqOvRiGFEoH6\\u000aYNOiosMN\\u000a=xuj5\\u000a-----END PGP PUBLIC KEY BLOCK-----\\u000a\"]}]}", null);
            System.out.println("Rule created with newid: " + newid);
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacation2Test() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}],\"id\":5}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":true,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":13,\"addresses\":[\"root@localhost\",\"billg@microsoft.com\"],\"subject\":\"Betreff\",\"text\":\"Text\\u000aText\"}],\"id\":5}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacation3Test() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"New x\",\"test\":{\"id\":\"header\",\"comparison\":\"contains\",\"values\":[\"\"],\"headers\":[\"X-Been-There\",\"X-Mailinglist\"]},\"actioncmds\":[{\"id\":\"redirect\",\"to\":\"xyz@bla.de\"}],\"flags\":[],\"active\":true}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"New x\",\"test\":{\"id\":\"header\",\"comparison\":\"contains\",\"values\":[\"\"],\"headers\":[\"X-Been-There\",\"X-Mailinglist\"]},\"actioncmds\":[{\"id\":\"redirect\",\"to\":\"xyz@bla.de\"}],\"flags\":[],\"active\":true}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationDeactiveAtTheEndTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewVacationDeactiveInBetweenTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"Vacation Notice\",\"position\":0,\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"Vacation Notice\",\"position\":0,\"active\":false,\"flags\":[\"vacation\"],\"test\":{\"id\":\"true\"},\"actioncmds\":[{\"id\":\"vacation\",\"days\":1,\"addresses\":[\"dsfa\"],\"subject\":\"123\",\"text\":\"123\"}]}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewSizeTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"rulename\":\"sizerule\",\"test\":{\"id\":\"size\",\"comparison\":\"over\",\"size\":88},\"actioncmds\":[{\"id\":\"keep\"}],\"flags\":[],\"active\":true}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"rulename\":\"sizerule\",\"test\":{\"id\":\"size\",\"comparison\":\"over\",\"size\":88},\"actioncmds\":[{\"id\":\"keep\"}],\"flags\":[],\"active\":true}", null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewCurrentDateTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject base = new JSONObject();
            base.put("rulename", (Object)"sizerule");
            base.put("active", (Object)Boolean.TRUE);
            base.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"allof");
            test.append("tests", (Object)this.currentdate(1183759200000L, "ge", CurrentDate.date));
            test.append("tests", (Object)this.currentdate(1183759200000L, "le", CurrentDate.date));
            test.append("tests", (Object)this.currentdate(1183759200000L, "is", CurrentDate.date));
            base.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"dennis.sieben@open-xchange.com");
            action.put("text", (Object)"I'm out of office");
            base.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), base.toString(), null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    private JSONObject currentdate(long date, String comparison, CurrentDate cd) throws JSONException {
        JSONObject currentdate2 = new JSONObject();
        currentdate2.put("id", (Object)"currentdate");
        currentdate2.put("comparison", (Object)comparison);
        currentdate2.append("datevalue", (Object)date);
        currentdate2.put("datepart", (Object)cd.toString());
        return currentdate2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTestMissingHeaders() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", "Exception while parsing JSON: \"Error while reading TestCommand address: JSONObject[\"headers\"] not found.\".");
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilternewTestWithoutPosition() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}", null);
            this.mailfilterupdate(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"flags\":[],\"actioncmds\":[{\"into\":\"INBOX/Spam\",\"id\":\"move\"},{\"id\":\"stop\"}],\"id\":0,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"user\",\"id\":\"address\"},{\"headers\":[\"subject\"],\"values\":[\"Zitat des Tages\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}");
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterreorderTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "[5,7,8]";
            this.mailfilterreorder(login, this.getHostname(), this.getUsername(), "[5,7,8]");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterupdateTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":true,\"position\":0,\"flags\":[],\"id\":7,\"rulename\":\"testrule\"}";
            this.mailfilterupdate(login, this.getHostname(), this.getUsername(), "{\"active\":true,\"position\":0,\"flags\":[],\"id\":7,\"rulename\":\"testrule\"}");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterupdateTest2() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            String test = "{\"active\":false,\"position\":0,\"flags\":[],\"id\":7,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}";
            this.mailfilterupdate(login, this.getHostname(), this.getUsername(), "{\"active\":false,\"position\":0,\"flags\":[],\"id\":7,\"test\":{\"tests\":[{\"headers\":[\"from\"],\"values\":[\"zitate.at\"],\"comparison\":\"contains\",\"id\":\"header\"}],\"id\":\"allof\"},\"rulename\":\"\"}");
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfiltergetScriptTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfiltergetScript(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void MailfilterdeleteScriptTest() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            this.mailfilterdeleteScript(login, this.getHostname(), this.getUsername());
        }
        finally {
            this.logout(login);
        }
    }

    protected abstract String getHostname();

    protected abstract String getUsername();

    protected abstract WebconversationAndSessionID login() throws MalformedURLException, IOException, SAXException, JSONException;

    private void logout(WebconversationAndSessionID conversation) throws MalformedURLException, IOException, SAXException, JSONException {
        GetMethodWebRequest req = new GetMethodWebRequest(PROTOCOL + this.getHostname() + LOGOUT_URL);
        req.setParameter("action", "logout");
        req.setParameter("session", conversation.getSessionid());
        WebResponse resp = conversation.getWebConversation().getResponse((WebRequest)req);
        Assert.assertEquals((long)200L, (long)resp.getResponseCode());
    }

    private void setSessionParameter(WebconversationAndSessionID conversation, WebRequest reqmailfilter) {
        reqmailfilter.setParameter("session", conversation.getSessionid());
    }

    private void mailfilterdelete(WebconversationAndSessionID conversation, String hostname, String username, int number) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject object = new JSONObject();
        object.put("id", number);
        byte[] bytes = object.toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=delete&session=" + conversation.getSessionid() + "&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=delete&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        Assert.assertEquals((long)200L, (long)mailfilterresp.getResponseCode());
    }

    private void mailfilterlist(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "list");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.optJSONArray("error_params")), (boolean)json.has("error"));
        System.out.println("Rules:");
        System.out.println("------");
        JSONArray testJsonArray = json.getJSONArray("data");
        for (int i = 0; i < testJsonArray.length(); ++i) {
            System.out.println(testJsonArray.getJSONObject(i));
            System.out.println("Test: " + testJsonArray.getJSONObject(i).getJSONObject("test"));
            System.out.println("--------------");
        }
    }

    private void mailfilterconfig(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "config");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println("Tests:");
        System.out.println("------");
        JSONArray testJsonArray = json.getJSONObject("data").getJSONArray("tests");
        for (int i = 0; i < testJsonArray.length(); ++i) {
            System.out.println(testJsonArray.getJSONObject(i));
        }
        System.out.println("Actioncommands:" + json.getJSONObject("data").getJSONArray("actioncommands"));
    }

    private String mailfilternew(WebconversationAndSessionID conversation, String hostname, String username, String jsonString, String errorfound) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = jsonString.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&username=" + username + "&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&session=" + conversation.getSessionid(), (InputStream)bais, "text/javascript; charset=UTF-8");
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        if (null != errorfound) {
            Assert.assertTrue((String)"No error desc", (boolean)json.has("error_desc"));
            Assert.assertTrue((String)("The given error string: " + errorfound + " was not found in the error desc"), (boolean)json.optString("error_desc").contains(errorfound));
            return null;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        return json.getString("data");
    }

    private void mailfilterreorder(WebconversationAndSessionID conversation, String hostname, String username, String jsonArray) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = jsonArray.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=new&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=reorder", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfilterupdate(WebconversationAndSessionID conversation, String hostname, String username, String test) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        byte[] bytes = test.getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest reqmailfilter = null != username ? new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=update&username=" + username, (InputStream)bais, "text/javascript; charset=UTF-8") : new PutMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL + "?action=update", (InputStream)bais, "text/javascript; charset=UTF-8");
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfiltergetScript(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "getscript");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    private void mailfilterdeleteScript(WebconversationAndSessionID conversation, String hostname, String username) throws MalformedURLException, IOException, SAXException, JSONException {
        JSONObject json;
        GetMethodWebRequest reqmailfilter = new GetMethodWebRequest(PROTOCOL + hostname + MAILFILTER_URL);
        reqmailfilter.setParameter("action", "deletescript");
        if (null != username) {
            reqmailfilter.setParameter("username", username);
        }
        this.setSessionParameter(conversation, (WebRequest)reqmailfilter);
        WebResponse mailfilterresp = conversation.getWebConversation().getResponse((WebRequest)reqmailfilter);
        String body = mailfilterresp.getText();
        try {
            json = new JSONObject(body);
        }
        catch (JSONException e) {
            System.out.println("Can't parse this body to JSON: \"" + body + '\"');
            throw e;
        }
        Assert.assertFalse((String)String.format(json.optString("error"), json.opt("error_params")), (boolean)json.has("error"));
        System.out.println(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWeekDayField() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject rule = new JSONObject();
            rule.put("rulename", (Object)"weekday rule");
            rule.put("active", (Object)Boolean.TRUE);
            rule.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"allof");
            test.append("tests", (Object)this.currentdate(3L, "is", CurrentDate.weekday));
            rule.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"foo@invalid.tld");
            action.put("text", (Object)"I'm out of office");
            rule.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), rule.toString(), null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDateField() throws MalformedURLException, IOException, SAXException, JSONException {
        WebconversationAndSessionID login = this.login();
        try {
            JSONObject rule = new JSONObject();
            rule.put("rulename", (Object)"time rule");
            rule.put("active", (Object)Boolean.TRUE);
            rule.append("flags", (Object)"vacation");
            JSONObject test = new JSONObject();
            test.put("id", (Object)"allof");
            test.append("tests", (Object)this.currentdate(3627279000000L, "is", CurrentDate.time));
            rule.put("test", (Object)test);
            JSONObject action = new JSONObject();
            action.put("id", (Object)"vacation");
            action.put("days", 7);
            action.append("addresses", (Object)"foo@invalid.tld");
            action.put("text", (Object)"I'm out of office");
            rule.append("actioncmds", (Object)action);
            String newid = this.mailfilternew(login, this.getHostname(), this.getUsername(), rule.toString(), null);
            System.out.println("Rule created with newid: " + newid);
            this.mailfilterdelete(login, this.getHostname(), this.getUsername(), Integer.parseInt(newid));
        }
        finally {
            this.logout(login);
        }
    }

    private static enum CurrentDate {
        date,
        time,
        weekday;

    }

    public class WebconversationAndSessionID {
        private final WebConversation webConversation;
        private final String sessionid;

        public WebconversationAndSessionID(WebConversation webConversation, String sessionid) {
            this.sessionid = sessionid;
            this.webConversation = webConversation;
        }

        public final WebConversation getWebConversation() {
            return this.webConversation;
        }

        public final String getSessionid() {
            return this.sessionid;
        }
    }
}

