/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.mail.actions.AbstractMailRequest;
import com.openexchange.ajax.mail.actions.ImportMailResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ImportMailRequest
extends AbstractMailRequest<ImportMailResponse> {
    private final String folder;
    private final InputStream[] rfc822;
    private final int flags;
    private final boolean failOnError;
    private final boolean preserveReceivedDate;
    private boolean strictParsing = true;

    public ImportMailRequest(String folder, int flags, boolean failOnError, InputStream ... rfc822) {
        this(folder, flags, failOnError, false, rfc822);
    }

    public ImportMailRequest(String folder, int flags, boolean failOnError, boolean preserveReceivedDate, InputStream ... rfc822) {
        this.preserveReceivedDate = preserveReceivedDate;
        this.folder = folder;
        this.rfc822 = rfc822;
        this.flags = flags;
        this.failOnError = failOnError;
    }

    public ImportMailRequest(String folder, int flags, InputStream ... rfc822) {
        this(folder, flags, true, rfc822);
    }

    public ImportMailRequest(String folder, int flags, Charset charset, String ... mails) {
        this(folder, flags, true, ImportMailRequest.toStreams(charset, mails));
    }

    public ImportMailRequest setStrictParsing(boolean strictParsing) {
        this.strictParsing = strictParsing;
        return this;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.UPLOAD;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> list = new LinkedList<AJAXRequest.Parameter>();
        list.add(new AJAXRequest.URLParameter("action", "import"));
        list.add(new AJAXRequest.URLParameter("folder", this.folder));
        list.add(new AJAXRequest.URLParameter("force", "true"));
        list.add(new AJAXRequest.URLParameter("preserveReceivedDate", this.preserveReceivedDate));
        list.add(new AJAXRequest.URLParameter("strictParsing", this.strictParsing));
        if (this.flags >= 0) {
            list.add(new AJAXRequest.URLParameter("flags", this.flags));
        }
        int i = 0;
        for (InputStream is : this.rfc822) {
            list.add(new AJAXRequest.FileParameter("mail" + i++, "mail.eml", is, "text/rfc822"));
        }
        return list.toArray(new AJAXRequest.Parameter[list.size()]);
    }

    @Override
    public AbstractAJAXParser<ImportMailResponse> getParser() {
        return new AbstractAJAXParser<ImportMailResponse>(this.failOnError){

            @Override
            protected ImportMailResponse createResponse(Response response) throws JSONException {
                ImportMailResponse retval = new ImportMailResponse(response);
                Object tmp = response.getData();
                if (tmp instanceof JSONObject) {
                    JSONObject json = (JSONObject)response.getData();
                    retval.setIds(new String[][]{this.parseIds(json)});
                } else if (tmp instanceof JSONArray) {
                    JSONArray json = (JSONArray)response.getData();
                    String[][] ids = new String[json.length()][];
                    for (int i = 0; i < json.length(); ++i) {
                        ids[i] = this.parseIds(json.getJSONObject(i));
                    }
                    retval.setIds(ids);
                }
                return retval;
            }

            private String[] parseIds(JSONObject json) throws JSONException {
                String[] retval = new String[2];
                if (json.has("folder_id")) {
                    retval[0] = json.getString("folder_id");
                }
                if (json.has("id")) {
                    retval[1] = json.getString("id");
                }
                return retval;
            }
        };
    }

    private static final InputStream[] toStreams(Charset charset, String ... mails) {
        InputStream[] retval = new InputStream[mails.length];
        for (int i = 0; i < mails.length; ++i) {
            ByteBuffer buffer = charset.encode(mails[i]);
            retval[i] = new ByteArrayInputStream(buffer.array(), buffer.position(), buffer.limit());
        }
        return retval;
    }
}

