/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.ajax.mail.actions.UpdateMailRequest;
import com.openexchange.ajax.mail.actions.UpdateMailResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.mail.MailListField;
import com.openexchange.mail.MailSortField;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.Date;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class UpdateMailTest
extends AbstractMailTest {
    private UserValues values;

    public UpdateMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getInboxFolder());
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testShouldBeAbleToAddFlags() throws OXException, IOException, SAXException, JSONException {
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        NewMailRequest newMailRequest = new NewMailRequest(this.values.getInboxFolder(), eml, -1, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        String folder = newMailResponse.getFolder();
        String id = newMailResponse.getId();
        UpdateMailRequest updateRequest = new UpdateMailRequest(folder, id);
        boolean additionalFlag = true;
        updateRequest.setFlags(1);
        updateRequest.updateFlags();
        UpdateMailResponse updateResponse = this.getClient().execute(updateRequest);
        TestMail updatedMail = this.getMail(folder, id);
        UpdateMailTest.assertTrue((String)("Flag should have been changed, but are: " + Integer.toBinaryString(updatedMail.getFlags())), ((updatedMail.getFlags() & 1) == 1 ? 1 : 0) != 0);
        updateRequest = new UpdateMailRequest(folder, id);
        updateRequest.setFlags(1);
        updateRequest.removeFlags();
        updateResponse = this.getClient().execute(updateRequest);
        updatedMail = this.getMail(folder, id);
        UpdateMailTest.assertTrue((String)("Flag should have been changed back again, but are: " + Integer.toBinaryString(updatedMail.getFlags())), ((updatedMail.getFlags() & 1) == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testShouldBeAbleToAddFlags2AllMessages() throws OXException, IOException, SAXException, JSONException {
        String newId = null;
        try {
            Object[][] array;
            FolderObject fo = new FolderObject();
            String inboxFolder = this.values.getInboxFolder();
            String name = "TestFolder" + System.currentTimeMillis();
            String fullName = inboxFolder + "/" + name;
            fo.setFullName(fullName);
            fo.setFolderName(name);
            fo.setModule(7);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest request = new InsertRequest((API)EnumAPI.OUTLOOK, fo);
            InsertResponse response = this.client.execute(request);
            newId = (String)response.getResponse().getData();
            String eml = "Message-Id: <4A002517.4650.0059.1@deployfast.com>\nX-Mailer: Novell GroupWise Internet Agent 8.0.0 \nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Re: Your order for East Texas Lighthouse\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
            for (int i = 0; i < 10; ++i) {
                NewMailRequest newMailRequest = new NewMailRequest(newId, eml, -1, true);
                NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
                String folder = newMailResponse.getFolder();
                UpdateMailTest.assertNotNull((String)"Missing folder in response.", (Object)folder);
                UpdateMailTest.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
                UpdateMailTest.assertEquals((String)"Folder ID mismatch in newly appended message.", (String)newId, (String)folder);
            }
            boolean flag = true;
            UpdateMailRequest updateRequest = new UpdateMailRequest(newId);
            boolean additionalFlag = true;
            updateRequest.setFlags(1);
            updateRequest.updateFlags();
            UpdateMailResponse updateResponse = this.getClient().execute(updateRequest);
            UpdateMailTest.assertEquals((String)"Folder ID mismatch.", (String)newId, (String)updateResponse.getFolder());
            AllRequest allRequest = new AllRequest(newId, new int[]{MailListField.ID.getField(), MailListField.FLAGS.getField()}, MailSortField.RECEIVED_DATE.getField(), Order.ASCENDING, true);
            AllResponse allResponse = this.getClient().execute(allRequest);
            for (Object[] arr : array = allResponse.getArray()) {
                Integer flags = (Integer)arr[1];
                UpdateMailTest.assertTrue((String)("\\Seen flag not set for message " + arr[0] + " in folder " + newId), ((flags & 1) > 0 ? 1 : 0) != 0);
            }
            if (null == newId) return;
        }
        catch (Throwable throwable) {
            if (null == newId) throw throwable;
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                this.client.execute(deleteRequest);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
            this.client.execute(deleteRequest);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testShouldBeAbleToAddColorLabel2AllMessages() throws OXException, IOException, SAXException, JSONException {
        String newId = null;
        try {
            Object[][] array;
            FolderObject fo = new FolderObject();
            String inboxFolder = this.values.getInboxFolder();
            String name = "TestFolder" + System.currentTimeMillis();
            String fullName = inboxFolder + "/" + name;
            fo.setFullName(fullName);
            fo.setFolderName(name);
            fo.setModule(7);
            OCLPermission oclP = new OCLPermission();
            oclP.setEntity(this.client.getValues().getUserId());
            oclP.setGroupPermission(false);
            oclP.setFolderAdmin(true);
            oclP.setAllPermission(128, 128, 128, 128);
            fo.setPermissionsAsArray(new OCLPermission[]{oclP});
            InsertRequest request = new InsertRequest((API)EnumAPI.OUTLOOK, fo);
            InsertResponse response = this.client.execute(request);
            newId = (String)response.getResponse().getData();
            String eml = "Message-Id: <4A002517.4650.0059.1@deployfast.com>\nX-Mailer: Novell GroupWise Internet Agent 8.0.0 \nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Re: Your order for East Texas Lighthouse\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
            for (int i = 0; i < 10; ++i) {
                NewMailRequest newMailRequest = new NewMailRequest(newId, eml, -1, true);
                NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
                String folder = newMailResponse.getFolder();
                UpdateMailTest.assertNotNull((String)"Missing folder in response.", (Object)folder);
                UpdateMailTest.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
                UpdateMailTest.assertEquals((String)"Folder ID mismatch in newly appended message.", (String)newId, (String)folder);
            }
            int colorLable = 5;
            UpdateMailRequest updateRequest = new UpdateMailRequest(newId);
            updateRequest.setColor(5);
            UpdateMailResponse updateResponse = this.getClient().execute(updateRequest);
            UpdateMailTest.assertEquals((String)"Folder ID mismatch.", (String)newId, (String)updateResponse.getFolder());
            AllRequest allRequest = new AllRequest(newId, new int[]{MailListField.ID.getField(), MailListField.COLOR_LABEL.getField()}, MailSortField.RECEIVED_DATE.getField(), Order.ASCENDING, true);
            AllResponse allResponse = this.getClient().execute(allRequest);
            for (Object[] arr : array = allResponse.getArray()) {
                Integer label = (Integer)arr[1];
                UpdateMailTest.assertEquals((String)("Color label not set for message " + arr[0] + " in folder " + newId), (int)5, (int)label);
            }
            if (null == newId) return;
        }
        catch (Throwable throwable) {
            if (null == newId) throw throwable;
            try {
                DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
                this.client.execute(deleteRequest);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            DeleteRequest deleteRequest = new DeleteRequest((API)EnumAPI.OUTLOOK, newId, new Date());
            this.client.execute(deleteRequest);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void notestShouldBeAbleToAddFlagsByMessageId() throws OXException, IOException, SAXException, JSONException {
        String mail = this.values.getSendAddress();
        this.sendMail(this.createEMail(mail, "Update test for adding and removing a flag by message id", "ALTERNATE", "Just a little bit").toString());
        TestMail myMail = new TestMail(this.getFirstMailInFolder(this.values.getInboxFolder()));
        Object obj = myMail.getHeader("Message-ID");
        String messageId = null == obj ? null : obj.toString();
        UpdateMailTest.assertNotNull((String)"Message-ID header not found.", (Object)messageId);
        UpdateMailRequest updateRequest = new UpdateMailRequest(myMail.getFolder(), messageId).setMessageId(true);
        boolean additionalFlag = true;
        updateRequest.setFlags(1);
        updateRequest.updateFlags();
        UpdateMailResponse updateResponse = this.getClient().execute(updateRequest);
        TestMail updatedMail = this.getMail(updateResponse.getFolder(), updateResponse.getID());
        UpdateMailTest.assertTrue((String)"Flag should have been changed", ((updatedMail.getFlags() & 1) == 1 ? 1 : 0) != 0);
        updateRequest.removeFlags();
        updateResponse = this.getClient().execute(updateRequest);
        updatedMail = this.getMail(updateResponse.getFolder(), updateResponse.getID());
        UpdateMailTest.assertTrue((String)"Flag should have been changed back again", ((updatedMail.getFlags() & 1) == 0 ? 1 : 0) != 0);
    }

    public void notestShouldBeAbleToSetColors() throws OXException, IOException, SAXException, JSONException {
        String mail = this.values.getSendAddress();
        this.sendMail(this.createEMail(mail, "Update test for changing colors", "ALTERNATE", "Just a little bit").toString());
        TestMail myMail = new TestMail(this.getFirstMailInFolder(this.values.getInboxFolder()));
        UpdateMailRequest updateRequest = new UpdateMailRequest(myMail.getFolder(), myMail.getId());
        int myColor = 8;
        updateRequest.setColor(myColor);
        UpdateMailResponse updateResponse = this.getClient().execute(updateRequest);
        TestMail updatedMail = this.getMail(updateResponse.getFolder(), updateResponse.getID());
        UpdateMailTest.assertEquals((String)"Color should have been changed", (int)myColor, (int)updatedMail.getColor());
        myColor = 4;
        updateRequest.setColor(myColor);
        updateResponse = this.getClient().execute(updateRequest);
        updatedMail = this.getMail(updateResponse.getFolder(), updateResponse.getID());
        UpdateMailTest.assertEquals((String)"Color should have been changed again", (int)myColor, (int)updatedMail.getColor());
    }
}

