/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.MailSearchRequest;
import com.openexchange.ajax.mail.actions.MailSearchResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.exception.OXException;
import com.openexchange.mail.MailListField;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailSearchTest
extends AbstractMailTest {
    private String folder;

    public MailSearchTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.folder = this.getInboxFolder();
        this.clearFolder(this.folder);
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.folder);
        super.tearDown();
    }

    public void testSearch() throws Exception {
        String searchText = "Your order";
        JSONArray search = this.searchBySubject("Your order");
        MailSearchTest.assertEquals((String)"Should not yield results in empty folder.", (int)0, (int)search.length());
        String eml = "Message-Id: <4A002517.4650.0059.1>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Your order\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Your order");
        MailSearchTest.assertEquals((String)"Should yield one result.", (int)1, (int)search.length());
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Your order");
        MailSearchTest.assertEquals((String)"Should yield two results when facing two identical mails.", (int)2, (int)search.length());
        eml = "Message-Id: <4A002517.4650.0059.1>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Barfoo\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"UTF-8\"\n" + "Content-Transfer-Encoding: 8bit\n" + "\n" + "This is a MIME message. If you are reading this text, you may want to \n" + "consider changing to a mail reader or gateway that understands how to \n" + "properly handle MIME multipart messages.";
        this.getClient().execute(new NewMailRequest(this.folder, eml, -1, true));
        search = this.searchBySubject("Your order");
        MailSearchTest.assertEquals((String)"Should still yield two results after being sent a different one", (int)2, (int)search.length());
    }

    public JSONArray searchBySubject(String pattern) throws OXException, IOException, JSONException {
        JSONArray body = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("col", MailListField.SUBJECT.getField());
        obj.put("pattern", (Object)pattern);
        body.put((Object)obj);
        MailSearchRequest request = new MailSearchRequest(body, this.folder, COLUMNS_DEFAULT_LIST, 0, "asc", true);
        MailSearchResponse response = this.getClient().execute(request);
        return response.getDataAsJSONArray();
    }
}

