/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.GetRequest;
import com.openexchange.ajax.mail.actions.GetResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.ajax.mail.actions.NewMailResponse;
import com.openexchange.configuration.MailConfig;
import com.openexchange.exception.OXException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;

public class GetStructureTest
extends AbstractMailTest {
    private static final String attachment = GetStructureTest.readFile("attachment.base64");
    private static String eml = "Date: Tue, 27 Nov 2012 21:43:24 +0100 (CET)\nFrom: #ADDR#\nTo: #ADDR#\nMessage-ID: <1602561799.1706.1354049004437@open-xchange.com>\nSubject: Simple attachment\nMIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"----=_Part_1705_1673668315.1354049004384\"\n\n------=_Part_1705_1673668315.1354049004384\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 7bit\n\nSome text\n------=_Part_1705_1673668315.1354049004384\nContent-Type: image/jpeg; name=7.jpeg\nContent-Transfer-Encoding: base64\nContent-Disposition: attachment; filename=7.jpeg\n\n" + attachment + "\n" + "------=_Part_1705_1673668315.1354049004384--";
    private UserValues values;

    public GetStructureTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetStructure() throws OXException, IOException, JSONException {
        NewMailRequest newMailRequest = new NewMailRequest(null, eml.replaceAll("#ADDR#", this.values.getSendAddress()), -1, true);
        NewMailResponse newMailResponse = this.getClient().execute(newMailRequest);
        GetStructureTest.assertNotNull((String)"Missing folder in response.", (Object)newMailResponse.getFolder());
        GetStructureTest.assertNotNull((String)"Missing ID in response.", (Object)newMailResponse.getId());
        GetRequest newGetRequest = new GetRequest(newMailResponse.getFolder(), newMailResponse.getId(), true, true);
        GetResponse newGetResponse = this.getClient().execute(newGetRequest);
        String actualAttachment = ((JSONObject)newGetResponse.getData()).getJSONArray("body").getJSONObject(1).getJSONObject("body").getString("data");
        GetStructureTest.assertEquals((String)"Attachment has been modified", (String)attachment.replaceAll("(\\r|\\n)", ""), (String)actualAttachment);
    }

    private static String readFile(String fileName) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(MailConfig.getProperty(MailConfig.Property.TEST_MAIL_DIR) + fileName));
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

