/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.thirdparty.test;

import com.openexchange.ajax.infostore.thirdparty.AbstractInfostoreThirdpartyTest;
import com.openexchange.ajax.infostore.thirdparty.ProviderIdMapper;
import com.openexchange.ajax.infostore.thirdparty.actions.CreateFolderRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.CreateFolderResponse;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFileRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFileResponse;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFolderRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.DeleteFolderResponse;
import com.openexchange.ajax.infostore.thirdparty.actions.NewFileRequest;
import com.openexchange.ajax.infostore.thirdparty.actions.NewFileResponse;
import com.openexchange.java.Strings;
import java.util.List;

public class ThirdpartyLifecycleTest
extends AbstractInfostoreThirdpartyTest {
    private List<ProviderIdMapper> filestorages;

    public ThirdpartyLifecycleTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.filestorages = this.getConnectedInfostoreId();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLifecycle() throws Exception {
        String folderName = "unittest";
        byte[] file = this.randomBytes(5);
        for (ProviderIdMapper pid : this.filestorages) {
            String folderId = this.createFolder(pid, folderName);
            String fileId = this.uploadFile(folderId, file);
            this.deleteFile(folderId, fileId);
            this.deleteFolder(folderId);
        }
    }

    public String createFolder(ProviderIdMapper filestore, String folderName) throws Exception {
        CreateFolderRequest cfReq = new CreateFolderRequest(filestore.getInfostoreId(), folderName);
        CreateFolderResponse cfResp = this.client.execute(cfReq);
        ThirdpartyLifecycleTest.assertNotNull((String)"Folder was not successfully created: ", (Object)((Object)cfResp));
        String folderId = (String)cfResp.getData();
        return folderId;
    }

    public String uploadFile(String folderId, byte[] bytesToUpload) throws Exception {
        NewFileRequest nfReq = new NewFileRequest(bytesToUpload, this.setFolderId(folderId), "application/octet-stream");
        NewFileResponse nfResp = this.client.execute(nfReq);
        ThirdpartyLifecycleTest.assertNotNull((Object)"File was not successfully uploaded");
        String fileId = (String)nfResp.getData();
        ThirdpartyLifecycleTest.assertFalse((String)"File id is empty", (boolean)Strings.isEmpty((String)fileId));
        return fileId;
    }

    public void deleteFile(String folderId, String fileId) throws Exception {
        DeleteFileRequest dfReq = new DeleteFileRequest(fileId, folderId);
        DeleteFileResponse dfResp = this.client.execute(dfReq);
        ThirdpartyLifecycleTest.assertNotNull((Object)((Object)dfResp));
    }

    public void deleteFolder(String folderID) throws Exception {
        DeleteFolderRequest dfReq = new DeleteFolderRequest(folderID, 1);
        DeleteFolderResponse dfResp = this.client.execute(dfReq);
        ThirdpartyLifecycleTest.assertNotNull((Object)((Object)dfResp));
    }
}

