/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.test;

import com.openexchange.ajax.infostore.actions.GetDocumentRequest;
import com.openexchange.ajax.infostore.actions.GetDocumentResponse;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreRequest;
import com.openexchange.ajax.infostore.actions.UpdateInfostoreResponse;
import com.openexchange.ajax.infostore.test.AbstractInfostoreTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.java.Streams;
import com.openexchange.java.util.UUIDs;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class AppendDocumentTest
extends AbstractInfostoreTest {
    public AppendDocumentTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendFile() throws Exception {
        long offset;
        Date timestamp;
        DefaultFile document;
        String folderId = String.valueOf(this.client.getValues().getPrivateInfostoreFolder());
        long expectedLength = 0L;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int i = 0; i < 10; ++i) {
            byte[] chunk = UUIDs.toByteArray((UUID)UUID.randomUUID());
            chunks.add(chunk);
            expectedLength += (long)chunk.length;
        }
        byte[] expectedData = new byte[(int)expectedLength];
        int offset2 = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, expectedData, offset2, chunk.length);
            offset2 += chunk.length;
        }
        File tempFile = null;
        try {
            FileOutputStream outputStream = null;
            try {
                tempFile = File.createTempFile("test", "bin");
                tempFile.deleteOnExit();
                outputStream = new FileOutputStream(tempFile);
                outputStream.write((byte[])chunks.get(0));
                outputStream.flush();
            }
            catch (Throwable throwable) {
                Streams.close(outputStream);
                throw throwable;
            }
            Streams.close((Closeable)outputStream);
            document = new DefaultFile();
            document.setFolderId(folderId);
            document.setTitle(tempFile.getName());
            document.setFileName(tempFile.getName());
            document.setVersion(String.valueOf(1));
            document.setFileSize(tempFile.length());
            this.infoMgr.newAction((com.openexchange.file.storage.File)document, tempFile);
            timestamp = this.infoMgr.getLastResponse().getTimestamp();
            offset = tempFile.length();
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
        for (int i = 1; i < chunks.size(); ++i) {
            try {
                FileOutputStream outputStream = null;
                try {
                    tempFile = File.createTempFile("test", "bin");
                    tempFile.deleteOnExit();
                    outputStream = new FileOutputStream(tempFile);
                    outputStream.write((byte[])chunks.get(i));
                    outputStream.flush();
                }
                catch (Throwable throwable) {
                    Streams.close(outputStream);
                    throw throwable;
                }
                Streams.close((Closeable)outputStream);
                UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest((com.openexchange.file.storage.File)document, new File.Field[0], tempFile, timestamp);
                updateRequest.setOffset(offset);
                UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
                AppendDocumentTest.assertFalse((boolean)updateResponse.hasError());
                timestamp = updateResponse.getTimestamp();
                offset += tempFile.length();
                continue;
            }
            finally {
                if (null != tempFile) {
                    tempFile.delete();
                }
            }
        }
        GetDocumentRequest getRequest = new GetDocumentRequest(folderId, document.getId());
        GetDocumentResponse getResponse = this.getClient().execute(getRequest);
        byte[] contents = getResponse.getContentAsByteArray();
        AppendDocumentTest.assertNotNull((Object)contents);
        AppendDocumentTest.assertEquals((int)((int)expectedLength), (int)contents.length);
        Assert.assertArrayEquals((byte[])expectedData, (byte[])contents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendWithWrongOffsetFile() throws Exception {
        long offset;
        Date timestamp;
        DefaultFile document;
        FileOutputStream outputStream;
        String folderId = String.valueOf(this.client.getValues().getPrivateInfostoreFolder());
        long expectedLength = 0L;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int i = 0; i < 10; ++i) {
            byte[] chunk = UUIDs.toByteArray((UUID)UUID.randomUUID());
            chunks.add(chunk);
            expectedLength += (long)chunk.length;
        }
        byte[] expectedData = new byte[(int)expectedLength];
        int offset2 = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, expectedData, offset2, chunk.length);
            offset2 += chunk.length;
        }
        File tempFile = null;
        try {
            outputStream = null;
            try {
                tempFile = File.createTempFile("test", "bin");
                tempFile.deleteOnExit();
                outputStream = new FileOutputStream(tempFile);
                outputStream.write(UUIDs.toByteArray((UUID)UUID.randomUUID()));
                outputStream.flush();
            }
            catch (Throwable throwable) {
                Streams.close(outputStream);
                throw throwable;
            }
            Streams.close((Closeable)outputStream);
            document = new DefaultFile();
            document.setFolderId(folderId);
            document.setTitle(tempFile.getName());
            document.setFileName(tempFile.getName());
            document.setVersion(String.valueOf(1));
            document.setFileSize(tempFile.length());
            this.infoMgr.newAction((com.openexchange.file.storage.File)document, tempFile);
            timestamp = this.infoMgr.getLastResponse().getTimestamp();
            offset = tempFile.length();
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
        try {
            outputStream = null;
            try {
                tempFile = File.createTempFile("test", "bin");
                tempFile.deleteOnExit();
                outputStream = new FileOutputStream(tempFile);
                outputStream.write(UUIDs.toByteArray((UUID)UUID.randomUUID()));
                outputStream.flush();
            }
            finally {
                Streams.close((Closeable)outputStream);
            }
            UpdateInfostoreRequest updateRequest = new UpdateInfostoreRequest((com.openexchange.file.storage.File)document, new File.Field[0], tempFile, timestamp);
            updateRequest.setOffset(offset + 12L);
            updateRequest.setFailOnError(false);
            UpdateInfostoreResponse updateResponse = this.getClient().execute(updateRequest);
            AppendDocumentTest.assertTrue((boolean)updateResponse.hasError());
            AppendDocumentTest.assertEquals((String)"FLS-0019", (String)updateResponse.getException().getErrorCode());
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
    }
}

