/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.infostore.actions.AbstractInfostoreRequest;
import com.openexchange.ajax.infostore.actions.ZipDocumentsResponse;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ZipDocumentsRequest
extends AbstractInfostoreRequest {
    private final List<IdVersionPair> pairs;
    private final String folderId;
    private final boolean failOnError;

    public ZipDocumentsRequest(List<IdVersionPair> pairs, String folderId) {
        this(pairs, folderId, true);
    }

    public ZipDocumentsRequest(List<IdVersionPair> pairs, String folderId, boolean failOnError) {
        this.pairs = pairs;
        this.folderId = folderId;
        this.failOnError = failOnError;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray ja = new JSONArray(this.pairs.size());
        for (IdVersionPair pair : this.pairs) {
            JSONObject jo = new JSONObject(3);
            jo.put("folder", (Object)this.folderId);
            jo.put("id", (Object)pair.getIdentifier());
            String version = pair.getVersion();
            if (null != version) {
                jo.put("version", (Object)version);
            }
            ja.put((Object)jo);
        }
        return ja;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "zipdocuments"), new AJAXRequest.Parameter("folder", this.folderId)};
    }

    @Override
    public AbstractAJAXParser<?> getParser() {
        return new ZipDocumentsParser(this.failOnError);
    }

    public static final class IdVersionPair {
        private final String identifier;
        private final String version;

        public IdVersionPair(String identifier, String version) {
            this.identifier = identifier;
            this.version = version;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getVersion() {
            return this.version;
        }
    }

    class ZipDocumentsParser
    extends AbstractAJAXParser<ZipDocumentsResponse> {
        ZipDocumentsParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected ZipDocumentsResponse createResponse(Response response) throws JSONException {
            return new ZipDocumentsResponse(response);
        }
    }
}

