/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.test.TestInit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ListTest
extends InfostoreAJAXTest {
    public ListTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        String[][] bothEntries = new String[2][2];
        bothEntries[0][1] = (String)this.clean.get(0);
        bothEntries[1][1] = (String)this.clean.get(1);
        bothEntries[0][0] = String.valueOf(this.folderId);
        bothEntries[1][0] = String.valueOf(this.folderId);
        this.checkEntries(bothEntries);
    }

    public void testSkipsMissingIds() throws Exception {
        String fantasyID = this.getFantasyID();
        String[][] entries = new String[4][2];
        entries[0][1] = (String)this.clean.get(0);
        entries[1][1] = String.valueOf(fantasyID);
        entries[2][1] = (String)this.clean.get(1);
        entries[3][1] = (String)this.clean.get(1);
        entries[0][0] = String.valueOf(this.folderId);
        entries[1][0] = String.valueOf(this.folderId);
        entries[2][0] = String.valueOf(this.folderId);
        entries[3][0] = fantasyID;
        this.checkEntries(entries);
    }

    public void testLastModifiedUTC() throws JSONException, IOException, SAXException {
        String[][] bothEntries = new String[2][2];
        bothEntries[0][1] = (String)this.clean.get(0);
        bothEntries[1][1] = (String)this.clean.get(1);
        bothEntries[0][0] = String.valueOf(this.folderId);
        bothEntries[1][0] = String.valueOf(this.folderId);
        Response res = this.list(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{6}, bothEntries);
        ListTest.assertNoError(res);
        JSONArray arr = (JSONArray)res.getData();
        int size = arr.length();
        ListTest.assertTrue((size > 0 ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray row = arr.optJSONArray(i);
            ListTest.assertTrue((row.length() == 1 ? 1 : 0) != 0);
            ListTest.assertNotNull((Object)row.optLong(0));
        }
    }

    public void testNumberOfVersions() throws JSONException, IOException, SAXException {
        String[][] entries = new String[1][2];
        entries[0][0] = String.valueOf(this.folderId);
        entries[0][1] = (String)this.clean.get(0);
        File upload = new File(TestInit.getTestProperty("ajaxPropertiesFile"));
        Response res = this.update(this.getWebConversation(), this.getHostName(), this.sessionId, (String)this.clean.get(0), Long.MAX_VALUE, this.m("description", "New description"), upload, "text/plain");
        ListTest.assertNoError(res);
        res = this.list(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{1, 711}, entries);
        JSONArray rows = (JSONArray)res.getData();
        boolean found = false;
        int size = rows.length();
        for (int i = 0; i < size; ++i) {
            JSONArray row = rows.getJSONArray(i);
            String id = row.getString(0);
            int numberOfVersions = row.getInt(1);
            if (!id.equals(this.clean.get(0))) continue;
            ListTest.assertEquals((int)1, (int)numberOfVersions);
            found = true;
        }
        ListTest.assertTrue((boolean)found);
    }

    public String getFantasyID() throws JSONException, IOException, SAXException {
        String id = "20000";
        Response res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        while (!res.getErrorMessage().contains("IFO-0300") && !res.getErrorMessage().contains("IFO-0438")) {
            id = id + 10000;
            res = this.get(this.getWebConversation(), this.getHostName(), this.sessionId, id);
        }
        return id;
    }

    public void checkEntries(String[][] infostore_ids) throws Exception {
        Response res = this.list(this.getWebConversation(), this.getHostName(), this.sessionId, new int[]{1, 700, 706, 701}, infostore_ids);
        ListTest.assertNoError(res);
        HashSet ids = new HashSet(this.clean);
        HashSet<String> descriptions = new HashSet<String>(Arrays.asList("test knowledge description", "test url description"));
        HashSet<String> urls = new HashSet<String>(Arrays.asList("http://www.open-xchange.com"));
        HashSet<String> titles = new HashSet<String>(Arrays.asList("test knowledge", "test url"));
        JSONArray entries = (JSONArray)res.getData();
        for (int i = 0; i < entries.length(); ++i) {
            JSONArray entry = entries.getJSONArray(i);
            ListTest.assertTrue((boolean)ids.remove(entry.getString(0)));
            ListTest.assertTrue((boolean)titles.remove(entry.getString(1)));
            ListTest.assertTrue((boolean)descriptions.remove(entry.getString(2)));
            urls.remove(entry.getString(3));
        }
        ListTest.assertTrue((boolean)ids.isEmpty());
        ListTest.assertTrue((boolean)descriptions.isEmpty());
        ListTest.assertTrue((boolean)urls.isEmpty());
        ListTest.assertTrue((boolean)titles.isEmpty());
    }
}

