/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.parser.InfostoreParser;
import com.openexchange.groupware.infostore.DocumentMetadata;
import junit.framework.TestCase;

public class InfostoreParserTest
extends TestCase {
    public void testParseObject() throws Exception {
        InfostoreParser parser = new InfostoreParser();
        DocumentMetadata dm = parser.getDocumentMetadata("{\"title\" : \"The title\", \"url\" : \"http://www.open-xchange.com\" , \"filename\" : \"test.txt\", \"file_mimetype\" :\"text/plain\", \"file_size\" : 12345, \"version\" : 1, \"description\" : \"Description\", \"file_md5sum\" : \"123n12b4askfa2\", \"folder_id\" : 23, \"categories\" : \"toll, fein, hervorragend, am tollsten\"}");
        InfostoreParserTest.assertEquals((String)"The title", (String)dm.getTitle());
        InfostoreParserTest.assertEquals((String)"http://www.open-xchange.com", (String)dm.getURL());
        InfostoreParserTest.assertEquals((String)"test.txt", (String)dm.getFileName());
        InfostoreParserTest.assertEquals((String)"text/plain", (String)dm.getFileMIMEType());
        InfostoreParserTest.assertEquals((long)12345L, (long)dm.getFileSize());
        InfostoreParserTest.assertEquals((int)1, (int)dm.getVersion());
        InfostoreParserTest.assertEquals((String)"123n12b4askfa2", (String)dm.getFileMD5Sum());
        InfostoreParserTest.assertEquals((long)23L, (long)dm.getFolderId());
        InfostoreParserTest.assertEquals((String)"toll, fein, hervorragend, am tollsten", (String)dm.getCategories());
        dm = parser.getDocumentMetadata("{\"title\" : \"The title\", \"url\" : \"http://www.open-xchange.com\" , \"filename\" : \"test.txt\", \"file_mimetype\" :\"text/plain\", \"file_size\" : 12345, \"description\" : \"Description\", \"file_md5sum\" : \"123n12b4askfa2\", \"folder_id\" : 23, \"categories\" : \"toll, fein, hervorragend, am tollsten\"}");
        InfostoreParserTest.assertEquals((int)0, (int)dm.getVersion());
    }
}

