/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.infostore;

import com.openexchange.ajax.InfostoreAJAXTest;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.file.storage.composition.FileID;
import java.io.IOException;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class DeleteTest
extends InfostoreAJAXTest {
    public DeleteTest(String name) {
        super(name);
    }

    public void testBasic() throws Exception {
        super.removeAll();
        Response res = this.all(this.getWebConversation(), this.getHostName(), this.sessionId, this.folderId, new int[]{1});
        DeleteTest.assertNoError(res);
        JSONArray a = (JSONArray)res.getData();
        DeleteTest.assertEquals((int)0, (int)a.length());
        this.clean.clear();
    }

    public void testConflict() throws Exception {
        String[][] toDelete = new String[this.clean.size()][2];
        for (int i = 0; i < toDelete.length; ++i) {
            toDelete[i][0] = String.valueOf(this.folderId);
            toDelete[i][1] = (String)this.clean.get(i);
        }
        String[] notDeleted = this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, 0L, toDelete);
        DeleteTest.assertEquals((int)toDelete.length, (int)notDeleted.length);
        HashSet<String> notDeletedExpect = new HashSet<String>(this.clean);
        for (String i : notDeleted) {
            DeleteTest.assertTrue((boolean)notDeletedExpect.remove(i));
        }
        DeleteTest.assertTrue((boolean)notDeletedExpect.isEmpty());
        this.removeDocumentsAndFolders();
        this.clean.clear();
        AJAXClient client = new AJAXClient(new AJAXSession(this.getWebConversation(), this.getHostName(), this.sessionId), false);
        String infostoreTrashFolder = String.valueOf(client.getValues().getInfostoreTrashFolder());
        notDeletedExpect = new HashSet();
        for (int i = 0; i < toDelete.length; ++i) {
            FileID fileID = new FileID(toDelete[i][1]);
            fileID.setFolderId(infostoreTrashFolder);
            String uniqueID = fileID.toUniqueID();
            toDelete[i][0] = infostoreTrashFolder;
            toDelete[i][1] = uniqueID;
            notDeletedExpect.add(uniqueID);
        }
        notDeleted = this.delete(this.getWebConversation(), this.getHostName(), this.sessionId, 0L, toDelete);
        DeleteTest.assertEquals((int)toDelete.length, (int)notDeleted.length);
        for (String i : notDeleted) {
            DeleteTest.assertTrue((boolean)notDeletedExpect.remove(i));
        }
        DeleteTest.assertTrue((boolean)notDeletedExpect.isEmpty());
    }

    public void testDeleteSingle() throws JSONException, IOException, SAXException {
        String[] notDeleted = this.deleteSingle(this.getWebConversation(), this.getHostName(), this.sessionId, Long.MAX_VALUE, this.folderId, (String)this.clean.get(this.clean.size() - 1));
        DeleteTest.assertEquals((int)0, (int)notDeleted.length);
    }
}

