/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.importexport.actions.CSVImportRequest;
import com.openexchange.ajax.importexport.actions.CSVImportResponse;
import com.openexchange.groupware.container.Contact;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.json.JSONArray;

public class Bug36687Test
extends AbstractManagedContactTest {
    public Bug36687Test(String name) {
        super(name);
    }

    public void testDetectSemicolonDelimiter() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false);
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Contact secondContact = this.manager.getAction(this.folderID, data.getJSONObject(1).getInt("id"));
        Bug36687Test.assertNotNull((String)"Second imported contact not found", (Object)secondContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in second contact", (Object)secondContact.getEmail1());
    }

    public void testDetectCommaDelimiter() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithComma(), false);
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Contact secondContact = this.manager.getAction(this.folderID, data.getJSONObject(1).getInt("id"));
        Bug36687Test.assertNotNull((String)"Second imported contact not found", (Object)secondContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in second contact", (Object)secondContact.getEmail1());
    }

    public void testAutoDetectEncoding() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false);
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Bug36687Test.assertEquals((String)"Wrong name", (String)"Heinz\u0160", (String)firstContact.getSurName());
    }

    public void testAutoDetectEncoding2() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false, new AJAXRequest.Parameter("charset", "auto"));
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Bug36687Test.assertEquals((String)"Wrong name", (String)"Heinz\u0160", (String)firstContact.getSurName());
    }

    public void testSupplyEncoding() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false, new AJAXRequest.Parameter("charset", "cp1252"));
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Bug36687Test.assertEquals((String)"Wrong name", (String)"Heinz\u0160", (String)firstContact.getSurName());
    }

    public void testSupplyWrongEncoding() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false, new AJAXRequest.Parameter("charset", "UTF-8"));
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertFalse((String)"response has error", (boolean)response.hasError());
        JSONArray data = (JSONArray)response.getData();
        Bug36687Test.assertNotNull((String)"got no data", (Object)data);
        Bug36687Test.assertEquals((int)2, (int)data.length());
        Bug36687Test.assertTrue((String)"No object ID for first contact", (boolean)data.getJSONObject(0).has("id"));
        Bug36687Test.assertTrue((String)"No object ID for second contact", (boolean)data.getJSONObject(1).has("id"));
        Contact firstContact = this.manager.getAction(this.folderID, data.getJSONObject(0).getInt("id"));
        Bug36687Test.assertNotNull((String)"First imported contact not found", (Object)firstContact);
        Bug36687Test.assertNotNull((String)"No E-Mail found in first contact", (Object)firstContact.getEmail1());
        Bug36687Test.assertEquals((String)"Wrong name", (String)"Heinz\ufffd", (String)firstContact.getSurName());
    }

    public void testSupplyInvalidEncoding() throws Exception {
        CSVImportRequest request = new CSVImportRequest(this.folderID, Bug36687Test.getCSVFileWithSemicolon(), false, new AJAXRequest.Parameter("charset", "Deutsch"));
        CSVImportResponse response = this.getClient().execute(request);
        Bug36687Test.assertNotNull((String)"No response", (Object)((Object)response));
        Bug36687Test.assertTrue((String)"No errors in response", (boolean)response.hasError());
        Bug36687Test.assertEquals((String)"Unexepcted error code", (String)"I_E-1318", (String)response.getException().getErrorCode());
    }

    private static InputStream getCSVFileWithSemicolon() {
        byte[] csv = new byte[]{68, 105, 115, 112, 108, 97, 121, 32, 110, 97, 109, 101, 59, 83, 117, 114, 32, 110, 97, 109, 101, 59, 71, 105, 118, 101, 110, 32, 110, 97, 109, 101, 59, 77, 105, 100, 100, 108, 101, 32, 110, 97, 109, 101, 59, 83, 117, 102, 102, 105, 120, 59, 84, 105, 116, 108, 101, 59, 83, 116, 114, 101, 101, 116, 32, 104, 111, 109, 101, 59, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 104, 111, 109, 101, 59, 67, 105, 116, 121, 32, 104, 111, 109, 101, 59, 83, 116, 97, 116, 101, 32, 104, 111, 109, 101, 59, 67, 111, 117, 110, 116, 114, 121, 32, 104, 111, 109, 101, 59, 77, 97, 114, 105, 116, 97, 108, 32, 115, 116, 97, 116, 117, 115, 59, 78, 117, 109, 98, 101, 114, 32, 111, 102, 32, 99, 104, 105, 108, 100, 114, 101, 110, 59, 80, 114, 111, 102, 101, 115, 115, 105, 111, 110, 59, 78, 105, 99, 107, 110, 97, 109, 101, 59, 83, 112, 111, 117, 115, 101, 32, 110, 97, 109, 101, 59, 78, 111, 116, 101, 59, 67, 111, 109, 112, 97, 110, 121, 59, 68, 101, 112, 97, 114, 116, 109, 101, 110, 116, 59, 80, 111, 115, 105, 116, 105, 111, 110, 59, 69, 109, 112, 108, 111, 121, 101, 101, 32, 116, 121, 112, 101, 59, 82, 111, 111, 109, 32, 110, 117, 109, 98, 101, 114, 59, 83, 116, 114, 101, 101, 116, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 67, 105, 116, 121, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 83, 116, 97, 116, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 67, 111, 117, 110, 116, 114, 121, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 69, 109, 112, 108, 111, 121, 101, 101, 32, 73, 68, 59, 83, 97, 108, 101, 115, 32, 118, 111, 108, 117, 109, 101, 59, 84, 97, 120, 32, 105, 100, 59, 67, 111, 109, 109, 101, 114, 99, 105, 97, 108, 32, 114, 101, 103, 105, 115, 116, 101, 114, 59, 66, 114, 97, 110, 99, 104, 101, 115, 59, 66, 117, 115, 105, 110, 101, 115, 115, 32, 99, 97, 116, 101, 103, 111, 114, 121, 59, 73, 110, 102, 111, 59, 77, 97, 110, 97, 103, 101, 114, 39, 115, 32, 110, 97, 109, 101, 59, 65, 115, 115, 105, 115, 116, 97, 110, 116, 39, 115, 32, 110, 97, 109, 101, 59, 83, 116, 114, 101, 101, 116, 32, 111, 116, 104, 101, 114, 59, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 111, 116, 104, 101, 114, 59, 67, 105, 116, 121, 32, 111, 116, 104, 101, 114, 59, 83, 116, 97, 116, 101, 32, 111, 116, 104, 101, 114, 59, 67, 111, 117, 110, 116, 114, 121, 32, 111, 116, 104, 101, 114, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 97, 115, 115, 105, 115, 116, 97, 110, 116, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 32, 49, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 32, 50, 59, 70, 65, 88, 32, 98, 117, 115, 105, 110, 101, 115, 115, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 97, 108, 108, 98, 97, 99, 107, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 97, 114, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 111, 109, 112, 97, 110, 121, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 104, 111, 109, 101, 32, 49, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 104, 111, 109, 101, 32, 50, 59, 70, 65, 88, 32, 104, 111, 109, 101, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 73, 83, 68, 78, 59, 67, 101, 108, 108, 117, 108, 97, 114, 32, 116, 101, 108, 101, 112, 104, 111, 110, 101, 32, 49, 59, 67, 101, 108, 108, 117, 108, 97, 114, 32, 116, 101, 108, 101, 112, 104, 111, 110, 101, 32, 50, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 111, 116, 104, 101, 114, 59, 70, 65, 88, 32, 111, 116, 104, 101, 114, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 112, 97, 103, 101, 114, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 112, 114, 105, 109, 97, 114, 121, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 114, 97, 100, 105, 111, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 116, 101, 108, 101, 120, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 84, 84, 89, 47, 84, 68, 68, 59, 73, 110, 115, 116, 97, 110, 116, 109, 101, 115, 115, 101, 110, 103, 101, 114, 32, 49, 59, 73, 110, 115, 116, 97, 110, 116, 109, 101, 115, 115, 101, 110, 103, 101, 114, 32, 50, 59, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 73, 80, 59, 69, 109, 97, 105, 108, 32, 49, 59, 69, 109, 97, 105, 108, 32, 50, 59, 69, 109, 97, 105, 108, 32, 51, 59, 85, 82, 76, 59, 67, 97, 116, 101, 103, 111, 114, 105, 101, 115, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 50, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 51, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 52, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 53, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 54, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 55, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 56, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 57, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 48, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 49, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 50, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 51, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 52, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 53, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 54, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 55, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 56, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 57, 59, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 50, 48, 59, 79, 98, 106, 101, 99, 116, 32, 105, 100, 59, 68, 105, 115, 116, 114, 105, 98, 117, 116, 105, 111, 110, 32, 108, 105, 115, 116, 59, 70, 111, 108, 100, 101, 114, 32, 105, 100, 59, 67, 114, 101, 97, 116, 101, 100, 32, 98, 121, 59, 77, 111, 100, 105, 102, 105, 101, 100, 32, 98, 121, 59, 67, 114, 101, 97, 116, 105, 111, 110, 32, 100, 97, 116, 101, 59, 67, 104, 97, 110, 103, 105, 110, 103, 32, 100, 97, 116, 101, 59, 66, 105, 114, 116, 104, 100, 97, 121, 59, 65, 110, 110, 105, 118, 101, 114, 115, 97, 114, 121, 59, 68, 101, 102, 97, 117, 108, 116, 32, 97, 100, 100, 114, 101, 115, 115, 13, 72, 111, 114, 115, 116, 32, 72, 101, 105, 110, 122, -118, 59, 72, 101, 105, 110, 122, -118, 59, 72, 111, 114, 115, 116, 59, 59, 59, 59, 89, 108, -118, 109, 97, 97, 110, 116, 105, 101, 32, 50, 59, 59, 48, 50, 56, 56, 48, 32, 86, 101, 105, 107, 107, 111, 108, 97, 59, 59, 70, 105, 110, 108, 97, 110, 100, 59, 59, 59, 59, 59, 59, 59, 65, 99, 109, 101, 59, 77, 97, 110, 97, 103, 101, 109, 101, 110, 116, 59, 67, 69, 79, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 43, 51, 53, 56, 32, 52, 48, 48, 32, 54, 53, 53, 55, 48, 57, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 104, 111, 114, 115, 116, 46, 104, 101, 105, 110, 122, 97, 64, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 13, 79, 116, 116, 111, 32, 72, 101, 114, 98, 101, 114, 116, 59, 72, 101, 114, 98, 101, 114, 116, 59, 79, 116, 116, 111, 59, 59, 59, 59, 75, 97, 108, 101, 118, 97, 110, 107, 97, 116, 117, 32, 50, 51, 32, 65, 32, 50, 48, 59, 59, 48, 48, 49, 48, 48, 32, 72, 101, 108, 115, 105, 110, 107, 105, 59, 59, 70, 105, 110, 108, 97, 110, 100, 59, 59, 59, 59, 59, 59, 59, 65, 99, 109, 101, 59, 82, 101, 115, 101, 97, 114, 99, 104, 32, 38, 32, 68, 101, 118, 101, 108, 111, 112, 109, 101, 110, 116, 59, 67, 104, 105, 101, 102, 32, 65, 114, 99, 104, 105, 116, 101, 99, 116, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 43, 51, 53, 56, 32, 52, 48, 32, 55, 48, 48, 54, 52, 52, 50, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 111, 116, 116, 111, 46, 104, 101, 114, 98, 101, 114, 116, 64, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 13};
        return new ByteArrayInputStream(csv);
    }

    private static InputStream getCSVFileWithComma() {
        byte[] csv = new byte[]{68, 105, 115, 112, 108, 97, 121, 32, 110, 97, 109, 101, 44, 83, 117, 114, 32, 110, 97, 109, 101, 44, 71, 105, 118, 101, 110, 32, 110, 97, 109, 101, 44, 77, 105, 100, 100, 108, 101, 32, 110, 97, 109, 101, 44, 83, 117, 102, 102, 105, 120, 44, 84, 105, 116, 108, 101, 44, 83, 116, 114, 101, 101, 116, 32, 104, 111, 109, 101, 44, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 104, 111, 109, 101, 44, 67, 105, 116, 121, 32, 104, 111, 109, 101, 44, 83, 116, 97, 116, 101, 32, 104, 111, 109, 101, 44, 67, 111, 117, 110, 116, 114, 121, 32, 104, 111, 109, 101, 44, 77, 97, 114, 105, 116, 97, 108, 32, 115, 116, 97, 116, 117, 115, 44, 78, 117, 109, 98, 101, 114, 32, 111, 102, 32, 99, 104, 105, 108, 100, 114, 101, 110, 44, 80, 114, 111, 102, 101, 115, 115, 105, 111, 110, 44, 78, 105, 99, 107, 110, 97, 109, 101, 44, 83, 112, 111, 117, 115, 101, 32, 110, 97, 109, 101, 44, 78, 111, 116, 101, 44, 67, 111, 109, 112, 97, 110, 121, 44, 68, 101, 112, 97, 114, 116, 109, 101, 110, 116, 44, 80, 111, 115, 105, 116, 105, 111, 110, 44, 69, 109, 112, 108, 111, 121, 101, 101, 32, 116, 121, 112, 101, 44, 82, 111, 111, 109, 32, 110, 117, 109, 98, 101, 114, 44, 83, 116, 114, 101, 101, 116, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 67, 105, 116, 121, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 83, 116, 97, 116, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 67, 111, 117, 110, 116, 114, 121, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 69, 109, 112, 108, 111, 121, 101, 101, 32, 73, 68, 44, 83, 97, 108, 101, 115, 32, 118, 111, 108, 117, 109, 101, 44, 84, 97, 120, 32, 105, 100, 44, 67, 111, 109, 109, 101, 114, 99, 105, 97, 108, 32, 114, 101, 103, 105, 115, 116, 101, 114, 44, 66, 114, 97, 110, 99, 104, 101, 115, 44, 66, 117, 115, 105, 110, 101, 115, 115, 32, 99, 97, 116, 101, 103, 111, 114, 121, 44, 73, 110, 102, 111, 44, 77, 97, 110, 97, 103, 101, 114, 39, 115, 32, 110, 97, 109, 101, 44, 65, 115, 115, 105, 115, 116, 97, 110, 116, 39, 115, 32, 110, 97, 109, 101, 44, 83, 116, 114, 101, 101, 116, 32, 111, 116, 104, 101, 114, 44, 80, 111, 115, 116, 97, 108, 32, 99, 111, 100, 101, 32, 111, 116, 104, 101, 114, 44, 67, 105, 116, 121, 32, 111, 116, 104, 101, 114, 44, 83, 116, 97, 116, 101, 32, 111, 116, 104, 101, 114, 44, 67, 111, 117, 110, 116, 114, 121, 32, 111, 116, 104, 101, 114, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 97, 115, 115, 105, 115, 116, 97, 110, 116, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 32, 49, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 98, 117, 115, 105, 110, 101, 115, 115, 32, 50, 44, 70, 65, 88, 32, 98, 117, 115, 105, 110, 101, 115, 115, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 97, 108, 108, 98, 97, 99, 107, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 97, 114, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 99, 111, 109, 112, 97, 110, 121, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 104, 111, 109, 101, 32, 49, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 104, 111, 109, 101, 32, 50, 44, 70, 65, 88, 32, 104, 111, 109, 101, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 73, 83, 68, 78, 44, 67, 101, 108, 108, 117, 108, 97, 114, 32, 116, 101, 108, 101, 112, 104, 111, 110, 101, 32, 49, 44, 67, 101, 108, 108, 117, 108, 97, 114, 32, 116, 101, 108, 101, 112, 104, 111, 110, 101, 32, 50, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 111, 116, 104, 101, 114, 44, 70, 65, 88, 32, 111, 116, 104, 101, 114, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 112, 97, 103, 101, 114, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 112, 114, 105, 109, 97, 114, 121, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 114, 97, 100, 105, 111, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 116, 101, 108, 101, 120, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 84, 84, 89, 47, 84, 68, 68, 44, 73, 110, 115, 116, 97, 110, 116, 109, 101, 115, 115, 101, 110, 103, 101, 114, 32, 49, 44, 73, 110, 115, 116, 97, 110, 116, 109, 101, 115, 115, 101, 110, 103, 101, 114, 32, 50, 44, 84, 101, 108, 101, 112, 104, 111, 110, 101, 32, 73, 80, 44, 69, 109, 97, 105, 108, 32, 49, 44, 69, 109, 97, 105, 108, 32, 50, 44, 69, 109, 97, 105, 108, 32, 51, 44, 85, 82, 76, 44, 67, 97, 116, 101, 103, 111, 114, 105, 101, 115, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 50, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 51, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 52, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 53, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 54, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 55, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 56, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 57, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 48, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 49, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 50, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 51, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 52, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 53, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 54, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 55, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 56, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 49, 57, 44, 68, 121, 110, 97, 109, 105, 99, 32, 70, 105, 101, 108, 100, 32, 50, 48, 44, 79, 98, 106, 101, 99, 116, 32, 105, 100, 44, 68, 105, 115, 116, 114, 105, 98, 117, 116, 105, 111, 110, 32, 108, 105, 115, 116, 44, 70, 111, 108, 100, 101, 114, 32, 105, 100, 44, 67, 114, 101, 97, 116, 101, 100, 32, 98, 121, 44, 77, 111, 100, 105, 102, 105, 101, 100, 32, 98, 121, 44, 67, 114, 101, 97, 116, 105, 111, 110, 32, 100, 97, 116, 101, 44, 67, 104, 97, 110, 103, 105, 110, 103, 32, 100, 97, 116, 101, 44, 66, 105, 114, 116, 104, 100, 97, 121, 44, 65, 110, 110, 105, 118, 101, 114, 115, 97, 114, 121, 44, 68, 101, 102, 97, 117, 108, 116, 32, 97, 100, 100, 114, 101, 115, 115, 13, 72, 111, 114, 115, 116, 32, 72, 101, 105, 110, 122, -118, 44, 72, 101, 105, 110, 122, -118, 44, 72, 111, 114, 115, 116, 44, 44, 44, 44, 89, 108, -118, 109, 97, 97, 110, 116, 105, 101, 32, 50, 44, 44, 48, 50, 56, 56, 48, 32, 86, 101, 105, 107, 107, 111, 108, 97, 44, 44, 70, 105, 110, 108, 97, 110, 100, 44, 44, 44, 44, 44, 44, 44, 65, 99, 109, 101, 44, 77, 97, 110, 97, 103, 101, 109, 101, 110, 116, 44, 67, 69, 79, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 43, 51, 53, 56, 32, 52, 48, 48, 32, 54, 53, 53, 55, 48, 57, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 104, 111, 114, 115, 116, 46, 104, 101, 105, 110, 122, 97, 64, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 13, 79, 116, 116, 111, 32, 72, 101, 114, 98, 101, 114, 116, 44, 72, 101, 114, 98, 101, 114, 116, 44, 79, 116, 116, 111, 44, 44, 44, 44, 75, 97, 108, 101, 118, 97, 110, 107, 97, 116, 117, 32, 50, 51, 32, 65, 32, 50, 48, 44, 44, 48, 48, 49, 48, 48, 32, 72, 101, 108, 115, 105, 110, 107, 105, 44, 44, 70, 105, 110, 108, 97, 110, 100, 44, 44, 44, 44, 44, 44, 44, 65, 99, 109, 101, 44, 82, 101, 115, 101, 97, 114, 99, 104, 32, 38, 32, 68, 101, 118, 101, 108, 111, 112, 109, 101, 110, 116, 44, 67, 104, 105, 101, 102, 32, 65, 114, 99, 104, 105, 116, 101, 99, 116, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 43, 51, 53, 56, 32, 52, 48, 32, 55, 48, 48, 54, 52, 52, 50, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 111, 116, 116, 111, 46, 104, 101, 114, 98, 101, 114, 116, 64, 101, 120, 97, 109, 112, 108, 101, 46, 99, 111, 109, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 44, 13};
        return new ByteArrayInputStream(csv);
    }
}

