/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.SubscribeRequest;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.java.Autoboxing;
import com.openexchange.test.PermissionTools;
import java.util.Iterator;
import org.json.JSONArray;

public class SubscribeTest
extends AbstractAJAXSession {
    private FolderObject testFolder;
    private int appointmentFolder;

    public SubscribeTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testFolder = new FolderObject();
        this.testFolder.setModule(2);
        this.appointmentFolder = this.client.getValues().getPrivateAppointmentFolder();
        this.testFolder.setParentFolderID(this.appointmentFolder);
        this.testFolder.setPermissions(PermissionTools.P(Autoboxing.I((int)this.client.getValues().getUserId()), "a/a"));
        this.testFolder.setFolderName("SubscribeTest-" + System.currentTimeMillis());
        InsertRequest iReq = new InsertRequest((API)EnumAPI.OX_NEW, this.testFolder);
        InsertResponse iResp = this.client.execute(iReq);
        iResp.fillObject((DataObject)this.testFolder);
    }

    @Override
    protected void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest((API)EnumAPI.EAS_FOLDERS, this.testFolder));
        super.tearDown();
    }

    public void testSubscribe() throws Throwable {
        EnumAPI api = EnumAPI.EAS_FOLDERS;
        int fuid = this.testFolder.getObjectID();
        SubscribeRequest subscribeRequest = new SubscribeRequest(api, FolderStorage.ROOT_ID, true);
        subscribeRequest.addFolderId(Integer.toString(fuid), true);
        this.getClient().execute(subscribeRequest);
        int[] columns = new int[]{1, 20, 300, 301, 304, 308, 2, 3040};
        ListRequest listRequest = new ListRequest((API)api, FolderStorage.ROOT_ID, columns, true);
        ListResponse listResponse = this.client.execute(listRequest);
        boolean found = false;
        Iterator<FolderObject> iterator = listResponse.getFolder();
        while (iterator.hasNext()) {
            FolderObject folderObject = iterator.next();
            if (fuid != folderObject.getObjectID()) continue;
            found = true;
            break;
        }
        SubscribeTest.assertTrue((String)("Subscribed test folder could not be found in tree " + api.getTreeId()), (boolean)found);
        Iterator<FolderObject> iterator2 = listResponse.getFolder();
        while (iterator2.hasNext()) {
            FolderObject folderObject = iterator2.next();
            SubscribeTest.assertFalse((String)"Folder has subfolders, but shouldn't.", (boolean)folderObject.hasSubfolders());
        }
        JSONArray retArray = (JSONArray)listResponse.getData();
        int length = retArray.length();
        for (int i = 0; i < length; ++i) {
            JSONArray folderArray = retArray.getJSONArray(i);
            if (folderArray.getBoolean(5)) {
                SubscribeTest.assertTrue((String)"Should be preDefined, but isn't.", (boolean)folderArray.getBoolean(7));
                continue;
            }
            SubscribeTest.assertFalse((String)"Shouldn't be preDefined, but is.", (boolean)folderArray.getBoolean(7));
        }
    }
}

