/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.api2;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.util.ArrayList;

public class ChangePermissionsTest
extends AbstractAJAXSession {
    private AJAXClient client2;
    private FolderObject folder;
    private FolderObject secondFolder;
    private FolderTestManager ftm1;
    private FolderTestManager ftm2;
    private String folderName;

    public ChangePermissionsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.folderName = "ChangePermissionsTest Folder" + System.currentTimeMillis();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ftm1 = new FolderTestManager(this.client);
    }

    public void notestChangePermissionsSuccess() throws Exception {
        this.folder = this.ftm1.generatePublicFolder(this.folderName, 8, this.client.getValues().getPrivateInfostoreFolder(), this.client.getValues().getUserId());
        InsertRequest insertFolderReq = new InsertRequest((API)EnumAPI.OUTLOOK, this.folder, false);
        InsertResponse insertFolderResp = this.client.execute(insertFolderReq);
        ChangePermissionsTest.assertNull((String)"Inserting folder caused exception.", (Object)((Object)insertFolderResp.getException()));
        insertFolderResp.fillObject((DataObject)this.folder);
        ArrayList<OCLPermission> allPermissions = new ArrayList<OCLPermission>();
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(this.client.getValues().getUserId());
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(true);
        permissions.setAllPermission(128, 128, 128, 128);
        allPermissions.add(permissions);
        permissions = new OCLPermission();
        permissions.setEntity(this.client2.getValues().getUserId());
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(false);
        permissions.setAllPermission(2, 4, 0, 0);
        allPermissions.add(permissions);
        this.folder.setPermissions(allPermissions);
        this.folder = this.ftm1.updateFolderOnServer(this.folder);
        ChangePermissionsTest.assertTrue((String)"Unexpected number of permissions", (2 == this.folder.getNonSystemPermissionsAsArray().length ? 1 : 0) != 0);
    }

    public void testChangePermissionsFail() throws Exception {
        this.folder = this.ftm1.generatePublicFolder(this.folderName, 8, this.client.getValues().getInfostoreTrashFolder(), this.client.getValues().getUserId());
        InsertRequest insertFolderReq = new InsertRequest((API)EnumAPI.OUTLOOK, this.folder, false);
        InsertResponse insertFolderResp = this.client.execute(insertFolderReq);
        ChangePermissionsTest.assertNull((String)"Inserting folder caused exception.", (Object)((Object)insertFolderResp.getException()));
        insertFolderResp.fillObject((DataObject)this.folder);
        ArrayList<OCLPermission> allPermissions = new ArrayList<OCLPermission>();
        OCLPermission permissions = new OCLPermission();
        permissions.setEntity(this.client.getValues().getUserId());
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(true);
        permissions.setAllPermission(128, 128, 128, 128);
        allPermissions.add(permissions);
        permissions = new OCLPermission();
        permissions.setEntity(this.client2.getValues().getUserId());
        permissions.setGroupPermission(false);
        permissions.setFolderAdmin(false);
        permissions.setAllPermission(2, 4, 0, 0);
        allPermissions.add(permissions);
        this.folder.setPermissions(allPermissions);
        this.folder = this.ftm1.updateFolderOnServer(this.folder, false);
        AbstractAJAXResponse lastResponse = this.ftm1.getLastResponse();
        ChangePermissionsTest.assertNotNull((String)"Updating trash folder permissions not denied, but should.", (Object)((Object)lastResponse.getException()));
    }

    @Override
    protected void tearDown() throws Exception {
        this.ftm1.deleteFolderOnServer(this.folder);
        this.client2.logout();
        super.tearDown();
    }
}

