/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.ListParser;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.Modules;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.java.Strings;
import java.util.List;

public class ListRequest
extends AbstractFolderRequest<ListResponse> {
    public static final int[] DEFAULT_COLUMNS = new int[]{1, 20, 300, 301, 304, 308, 2, 306};
    private final String parentFolder;
    private final int[] columns;
    private final boolean ignoreMail;
    private final Modules[] allowedModules;
    private final boolean failOnError;
    private boolean altNames = false;

    public ListRequest(API api, String parentFolder, int[] columns, boolean ignoreMail, Modules[] allowedModules, boolean failOnError) {
        super(api);
        this.parentFolder = parentFolder;
        this.columns = columns;
        this.ignoreMail = ignoreMail;
        this.allowedModules = allowedModules;
        this.failOnError = failOnError;
    }

    public ListRequest(API api, String parentFolder, int[] columns, boolean ignoreMail, boolean failOnError) {
        this(api, parentFolder, columns, ignoreMail, null, failOnError);
    }

    public ListRequest(API api, String parentFolder, int[] columns, boolean ignoreMail) {
        this(api, parentFolder, columns, ignoreMail, null, true);
    }

    public ListRequest(API api, String parentFolder) {
        this(api, parentFolder, DEFAULT_COLUMNS, false);
    }

    public ListRequest(API api, int parentFolder) {
        this(api, Integer.toString(parentFolder), false);
    }

    public ListRequest(API api, String parentFolder, boolean ignoreMail) {
        this(api, parentFolder, DEFAULT_COLUMNS, ignoreMail);
    }

    public ListRequest(API api, String parentFolder, boolean ignoreMail, boolean failOnError) {
        this(api, parentFolder, DEFAULT_COLUMNS, ignoreMail, failOnError);
    }

    public ListRequest(API api, String parentFolder, Modules[] allowedModules) {
        this(api, parentFolder, DEFAULT_COLUMNS, false, allowedModules, true);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "list"));
        params.add(new AJAXRequest.Parameter("parent", this.parentFolder));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        if (this.ignoreMail) {
            params.add(new AJAXRequest.Parameter("ignore", "mailfolder"));
        }
        if (null != this.allowedModules && this.allowedModules.length > 0) {
            params.add(new AJAXRequest.Parameter("allowed_modules", Strings.join((Object[])this.allowedModules, (String)",")));
        }
        if (this.altNames) {
            params.add(new AJAXRequest.Parameter("altNames", Boolean.toString(this.altNames)));
        }
    }

    public ListParser getParser() {
        return new ListParser(this.columns, this.failOnError);
    }

    public void setAltNames(boolean altNames) {
        this.altNames = altNames;
    }
}

