/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.groupware.container.FolderObject;
import java.util.List;

public class GetRequest
extends AbstractFolderRequest<GetResponse> {
    private final boolean failOnError;
    private final String folderIdentifier;
    private final int[] columns;
    private boolean altNames = false;

    public GetRequest(API api, String folderIdentifier, int[] columns, boolean failOnError) {
        super(api);
        this.folderIdentifier = folderIdentifier;
        this.columns = columns;
        this.failOnError = failOnError;
    }

    public GetRequest(API api, String folderIdentifier, boolean failOnError) {
        this(api, folderIdentifier, FolderObject.ALL_COLUMNS, failOnError);
    }

    public GetRequest(API api, String folderIdentifier) {
        this(api, folderIdentifier, FolderObject.ALL_COLUMNS, true);
    }

    public GetRequest(API api, int folderId, int[] columns) {
        this(api, Integer.toString(folderId), columns, true);
    }

    public GetRequest(API api, String folderId, int[] columns) {
        this(api, folderId, columns, true);
    }

    public GetRequest(API api, int folderId) {
        this(api, Integer.toString(folderId), FolderObject.ALL_COLUMNS, true);
    }

    public GetRequest(API api, int folderId, boolean failOnError) {
        this(api, Integer.toString(folderId), FolderObject.ALL_COLUMNS, failOnError);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "get"));
        params.add(new AJAXRequest.Parameter("id", this.folderIdentifier));
        params.add(new AJAXRequest.Parameter("columns", this.columns));
        if (this.altNames) {
            params.add(new AJAXRequest.Parameter("altNames", Boolean.toString(this.altNames)));
        }
    }

    public GetParser getParser() {
        return new GetParser(this.failOnError);
    }

    protected String getFolderIdentifier() {
        return this.folderIdentifier;
    }

    protected int[] getColumns() {
        return this.columns;
    }

    public void setAltNames(boolean altNames) {
        this.altNames = altNames;
    }

    class GetParser
    extends AbstractAJAXParser<GetResponse> {
        GetParser(boolean failOnError) {
            super(failOnError);
        }

        @Override
        protected GetResponse createResponse(Response response) {
            return new GetResponse(response);
        }
    }
}

