/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.Modules;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.mail.utils.MailFolderUtility;
import java.util.Iterator;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTest
extends AbstractAJAXSession {
    private static final Logger LOG = LoggerFactory.getLogger(ListTest.class);
    private AJAXClient client;
    private AJAXClient client2;

    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
    }

    public void testListRoot() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_NEW, Integer.toString(0), new int[]{1, 304}, true);
        ListResponse response = this.client.execute(request);
        boolean privateFolder = false;
        boolean publicFolder = false;
        boolean sharedFolder = false;
        boolean infostoreFolder = false;
        JSONArray jsonArray = (JSONArray)response.getResponse().getData();
        int length = jsonArray.length();
        for (int i = 0; i < length; ++i) {
            JSONArray jsonSubArray = jsonArray.getJSONArray(i);
            int folderId = jsonSubArray.getInt(0);
            if (folderId == 1) {
                ListTest.assertTrue((String)"Subfolders expected below private folder.", (boolean)jsonSubArray.getBoolean(1));
                privateFolder = true;
                continue;
            }
            if (folderId == 2) {
                ListTest.assertTrue((String)"Subfolders expected below public folder.", (boolean)jsonSubArray.getBoolean(1));
                publicFolder = true;
                continue;
            }
            if (folderId == 3) {
                sharedFolder = true;
                continue;
            }
            if (folderId != 9) continue;
            ListTest.assertTrue((String)"Subfolders expected below infostore folder.", (boolean)jsonSubArray.getBoolean(1));
            infostoreFolder = true;
        }
        ListTest.assertTrue((String)"Private folder not found", (boolean)privateFolder);
        ListTest.assertTrue((String)"Public folder not found", (boolean)publicFolder);
        ListTest.assertTrue((String)"Shared folder not found", (boolean)sharedFolder);
        ListTest.assertTrue((String)"Infostore folder not found", (boolean)infostoreFolder);
        request = new ListRequest((API)EnumAPI.OX_NEW, String.valueOf(1));
        response = this.client.execute(request);
        Iterator<FolderObject> iter = response.getFolder();
        FolderObject defaultIMAPFolder = null;
        String primaryMailFolder = MailFolderUtility.prepareFullname((int)0, (String)"default");
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.containsFullName() || !primaryMailFolder.equals(fo.getFullName())) continue;
            defaultIMAPFolder = fo;
            break;
        }
        ListTest.assertNotNull((String)"Default email folder not found.", defaultIMAPFolder);
        boolean subFolders = defaultIMAPFolder.hasSubfolders();
        ListTest.assertTrue((String)"Default email folder has no subfolders.", (boolean)subFolders);
        request = new ListRequest((API)EnumAPI.OX_NEW, defaultIMAPFolder.getFullName());
        response = this.client.execute(request);
        iter = response.getFolder();
        FolderObject inboxFolder = null;
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.getFullName().endsWith("INBOX")) continue;
            inboxFolder = fo;
            break;
        }
        ListTest.assertNotNull((String)"Inbox folder for default mail account not found.", inboxFolder);
        GetRequest request2 = new GetRequest((API)EnumAPI.OX_NEW, inboxFolder.getFullName(), new int[]{1, 300, 305, 306});
        GetResponse response2 = this.client.execute(request2);
        ListTest.assertFalse((String)"Get failed.", (boolean)response2.hasError());
    }

    public void testListPrivate() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_NEW, String.valueOf(1));
        ListResponse response = this.client.execute(request);
        JSONArray jsonArray = (JSONArray)response.getResponse().getData();
        int length = jsonArray.length();
        ListTest.assertTrue((String)"Subfolders expected below private folder.", (length > 0 ? 1 : 0) != 0);
    }

    public void testListPrivateWithModules() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_NEW, String.valueOf(1), new Modules[]{Modules.MAIL});
        ListResponse response = this.client.execute(request);
        JSONArray jsonArray = (JSONArray)response.getResponse().getData();
        int length = jsonArray.length();
        ListTest.assertTrue((String)"Subfolders expected below private folder.", (length > 0 ? 1 : 0) != 0);
        Iterator<FolderObject> iter = response.getFolder();
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            LOG.info(folder.getFolderName() + ':' + folder.getFullName());
        }
    }

    public void testListPublic() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_NEW, String.valueOf(2));
        ListResponse response = this.client.execute(request);
        JSONArray jsonArray = (JSONArray)response.getResponse().getData();
        int length = jsonArray.length();
        ListTest.assertTrue((String)"Subfolders expected below public folder.", (length > 0 ? 1 : 0) != 0);
    }

    public void testListShared() throws Throwable {
        this.client.execute(new ListRequest((API)EnumAPI.OX_NEW, 0));
        this.client.execute(new ListRequest((API)EnumAPI.OX_NEW, 3));
        int folderId = this.client2.getValues().getPrivateAppointmentFolder();
        int userId = this.client.getValues().getUserId();
        FolderTools.shareFolder(this.client2, EnumAPI.OX_NEW, folderId, userId, 2, 4, 0, 0);
        ListRequest request1 = new ListRequest((API)EnumAPI.OX_NEW, 3);
        ListResponse response = this.client.execute(request1);
        String expectedId = "u:" + this.client2.getValues().getUserId();
        Iterator<FolderObject> iter = response.getFolder();
        FolderObject foundUserShared = null;
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (!expectedId.equals(folder.getFullName())) continue;
            foundUserShared = folder;
        }
        ListTest.assertNotNull((String)"Expected user named shared folder below root shared folder.", foundUserShared);
        ListRequest request2 = new ListRequest((API)EnumAPI.OX_NEW, foundUserShared.getFullName());
        response = this.client.execute(request2);
        iter = response.getFolder();
        FolderObject foundShared = null;
        while (iter.hasNext()) {
            FolderObject folder = iter.next();
            if (folderId != folder.getObjectID()) continue;
            foundShared = folder;
        }
        ListTest.assertNotNull((String)"Shared folder expected below shared parent folder.", foundShared);
        FolderTools.unshareFolder(this.client2, EnumAPI.OX_NEW, folderId, userId);
    }
}

