/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.ajax.framework.UserValues;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeleteFolderTest
extends AbstractAJAXSession {
    private AJAXClient secondClient;
    private UserValues secondUserValues;
    private FolderObject testFolder;
    private int parentId = -1;

    public DeleteFolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.secondClient = new AJAXClient(AJAXClient.User.User2);
        this.secondUserValues = this.secondClient.getValues();
        OCLPermission perm1 = Create.ocl(this.client.getValues().getUserId(), false, true, 128, 128, 128, 128);
        OCLPermission perm2 = Create.ocl(this.secondUserValues.getUserId(), false, true, 128, 128, 128, 128);
        this.parentId = 2;
        this.testFolder = Create.folder(this.parentId, "TestDeletion" + System.currentTimeMillis(), 2, 2, perm1, perm2);
        InsertRequest insFolder = new InsertRequest((API)EnumAPI.OX_OLD, this.testFolder);
        InsertResponse folderInsertResponse = this.secondClient.execute(insFolder);
        this.testFolder.setObjectID(folderInsertResponse.getId());
        this.testFolder.setLastModified(this.secondClient.execute(new GetRequest((API)EnumAPI.OX_OLD, this.testFolder.getObjectID())).getTimestamp());
    }

    @Override
    public void tearDown() throws Exception {
        if (this.testFolder != null) {
            this.secondClient.execute(new DeleteRequest((API)EnumAPI.OX_OLD, this.testFolder));
            this.testFolder = null;
            this.parentId = -1;
        }
        if (this.secondClient != null) {
            this.secondClient.logout();
            this.secondClient = null;
            this.secondUserValues = null;
        }
        super.tearDown();
    }

    public void testUnauthorizedDeletion() throws Throwable {
        int folderId = this.testFolder.getObjectID();
        List<FolderObject> l = FolderTools.getSubFolders(this.client, Integer.toString(2), true);
        DeleteFolderTest.assertTrue((String)("No public subfolders available for user " + this.client.getValues().getUserId()), (l != null && !l.isEmpty() ? 1 : 0) != 0);
        boolean found = false;
        for (FolderObject subfolder : l) {
            if (subfolder.getObjectID() != folderId) continue;
            found = true;
            break;
        }
        DeleteFolderTest.assertTrue((String)("Folder " + folderId + " not beneath public folder of user " + this.client.getValues().getUserId()), (boolean)found);
        GetRequest getQ = new GetRequest((API)EnumAPI.OX_OLD, folderId);
        GetResponse getR = this.secondClient.execute(getQ);
        FolderObject origFolder = getR.getFolder();
        ArrayList permissions = new ArrayList();
        permissions.addAll(origFolder.getPermissions());
        Iterator iter = permissions.iterator();
        while (iter.hasNext()) {
            if (((OCLPermission)iter.next()).getEntity() != this.client.getValues().getUserId()) continue;
            iter.remove();
        }
        FolderObject changed = new FolderObject();
        changed.setObjectID(folderId);
        changed.setLastModified(getR.getTimestamp());
        changed.setPermissions(permissions);
        UpdateRequest updQ = new UpdateRequest((API)EnumAPI.OX_OLD, changed);
        this.secondClient.execute(updQ);
        getQ = new GetRequest((API)EnumAPI.OX_OLD, folderId);
        getR = this.secondClient.execute(getQ);
        origFolder = getR.getFolder();
        origFolder.setLastModified(getR.getTimestamp());
        CommonDeleteResponse deleteResponse = this.client.execute(new DeleteRequest((API)EnumAPI.OX_OLD, false, origFolder).setFailOnErrorParam(Boolean.TRUE));
        DeleteFolderTest.assertTrue((String)"Delete attempt should have failed", (boolean)deleteResponse.hasError());
    }
}

