/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.AbstractObjectCountTest;
import com.openexchange.folderstorage.Folder;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Random;
import org.junit.Test;

public final class ContactObjectCountTest
extends AbstractObjectCountTest {
    private static final Random rand = new Random(System.currentTimeMillis());

    public ContactObjectCountTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPrivateFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        ContactTestManager ctm = new ContactTestManager(this.client1);
        try {
            FolderObject created = ContactObjectCountTest.createPrivateFolder(this.client1, ftm, 3);
            Folder folder = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numContacts = rand.nextInt(20) + 1;
            ContactObjectCountTest.createContacts(ctm, numContacts, created.getObjectID(), false);
            Folder reloaded = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)numContacts, (int)reloaded.getTotal());
        }
        finally {
            ctm.cleanUp();
            ftm.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInSharedFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        ContactTestManager ctm1 = new ContactTestManager(this.client1);
        ContactTestManager ctm2 = new ContactTestManager(this.client2);
        try {
            FolderObject created = ContactObjectCountTest.createSharedFolder(this.client1, 3, this.client2.getValues().getUserId(), ftm);
            Folder folder = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numContacts1 = rand.nextInt(20) + 1;
            int numPrivateContacts1 = rand.nextInt(20) + 1;
            int numContacts2 = rand.nextInt(20) + 1;
            ContactObjectCountTest.createContacts(ctm1, numContacts1, created.getObjectID(), false);
            ContactObjectCountTest.createContacts(ctm1, numPrivateContacts1, created.getObjectID(), true);
            ContactObjectCountTest.createContacts(ctm2, numContacts2, created.getObjectID(), false);
            Folder reloaded = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)(numContacts1 + numPrivateContacts1 + numContacts2), (int)reloaded.getTotal());
            reloaded = ContactObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)(numContacts1 + numContacts2), (int)reloaded.getTotal());
        }
        finally {
            ctm1.cleanUp();
            ctm2.cleanUp();
            ftm.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCountInPublicFolder() throws Exception {
        FolderTestManager ftm = new FolderTestManager(this.client1);
        ContactTestManager ctm1 = new ContactTestManager(this.client1);
        ContactTestManager ctm2 = new ContactTestManager(this.client2);
        try {
            FolderObject created = ContactObjectCountTest.createPublicFolder(this.client1, 3, this.client2.getValues().getUserId(), ftm);
            Folder folder = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)0, (int)folder.getTotal());
            int numContacts1 = rand.nextInt(20) + 1;
            int numContacts2 = rand.nextInt(20) + 1;
            ContactObjectCountTest.createContacts(ctm1, numContacts1, created.getObjectID(), false);
            ContactObjectCountTest.createContacts(ctm2, numContacts2, created.getObjectID(), false);
            Folder reloaded = ContactObjectCountTest.getFolder(this.client1, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)(numContacts1 + numContacts2), (int)reloaded.getTotal());
            reloaded = ContactObjectCountTest.getFolder(this.client2, created.getObjectID(), DEFAULT_COLUMNS);
            ContactObjectCountTest.assertEquals((String)"Wrong object count", (int)numContacts2, (int)reloaded.getTotal());
        }
        finally {
            ctm1.cleanUp();
            ctm2.cleanUp();
            ftm.cleanUp();
        }
    }

    private static void createContacts(ContactTestManager ctm, int numContacts, int folderId, boolean isPrivate) {
        Contact[] contacts = new Contact[numContacts];
        for (int i = 0; i < numContacts; ++i) {
            Contact contact = ContactTestManager.generateContact(folderId);
            contact.setPrivateFlag(isPrivate);
            contacts[i] = contact;
        }
        ctm.newActionMultiple(contacts);
    }
}

