/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.ArrayList;
import java.util.Iterator;

public class Bug16899Test
extends AbstractAJAXSession {
    private AJAXClient client;

    public Bug16899Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testBug16899() throws Exception {
        FolderObject folder = Create.createPrivateFolder("Bug 16899 Test", 7, this.client.getValues().getUserId(), new OCLPermission[0]);
        folder.setFullName("default0/INBOX/Bug 16899 Test");
        InsertRequest insertFolder = new InsertRequest((API)EnumAPI.OX_OLD, folder);
        InsertResponse execute = this.client.execute(insertFolder);
        execute.fillObject((DataObject)folder);
        String inbox = this.client.getValues().getInboxFolder();
        ArrayList<FolderObject> folders = this.performListRequest(inbox);
        boolean firstMatch = false;
        for (FolderObject f : folders) {
            if (!f.getFullName().equals(folder.getFullName())) continue;
            firstMatch = true;
            break;
        }
        Bug16899Test.assertTrue((String)"Testfolder not found in inbox.", (boolean)firstMatch);
        folders = null;
        DeleteRequest deleteFolder = new DeleteRequest((API)EnumAPI.OX_OLD, folder);
        CommonDeleteResponse deleteResponse = this.client.execute(deleteFolder);
        Bug16899Test.assertNull((String)"Error during folder deletion", (Object)((Object)deleteResponse.getException()));
        folders = this.performListRequest(inbox);
        boolean secondMatch = false;
        for (FolderObject f : folders) {
            if (!f.getFullName().equals(folder.getFullName())) continue;
            secondMatch = true;
            break;
        }
        Bug16899Test.assertFalse((String)"Testfolder was not deleted.", (boolean)secondMatch);
    }

    private ArrayList<FolderObject> performListRequest(String inFolder) throws Exception {
        ArrayList<FolderObject> folderList = new ArrayList<FolderObject>();
        ListRequest request = new ListRequest(EnumAPI.OUTLOOK, inFolder, FolderObject.ALL_COLUMNS, false, false);
        ListResponse response = this.client.execute(request);
        Bug16899Test.assertNull((String)"Error during ListRequest.", (Object)((Object)response.getException()));
        Iterator<FolderObject> iter = response.getFolder();
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            folderList.add(fo);
        }
        return folderList;
    }
}

