/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.DeleteRequest;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.InsertRequest;
import com.openexchange.ajax.folder.actions.InsertResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.folder.actions.UpdateRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.task.actions.SearchRequest;
import com.openexchange.ajax.task.actions.SearchResponse;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.search.TaskSearchObject;
import com.openexchange.server.impl.OCLPermission;
import java.util.Iterator;

public final class Bug16724Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private AJAXClient client2;
    private FolderObject folder;
    private int userId1;

    public Bug16724Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.userId1 = this.client.getValues().getUserId();
        this.folder = Create.createPrivateFolder("test for bug 16724_" + System.currentTimeMillis(), 1, this.client.getValues().getUserId(), new OCLPermission[0]);
        this.folder.setParentFolderID(this.client.getValues().getPrivateTaskFolder());
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.folder.addPermission(Create.ocl(this.client2.getValues().getUserId(), false, false, 2, 2, 0, 0));
        InsertResponse response = this.client.execute(new InsertRequest((API)EnumAPI.OUTLOOK, this.folder));
        response.fillObject((DataObject)this.folder);
        GetResponse response2 = this.client.execute(new GetRequest((API)EnumAPI.OUTLOOK, this.folder.getObjectID()));
        this.folder.setLastModified(response2.getTimestamp());
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest((API)EnumAPI.OUTLOOK, this.folder));
        super.tearDown();
    }

    public void testCachedAccess() throws Throwable {
        ListResponse listResponse1 = this.client2.execute(new ListRequest((API)EnumAPI.OUTLOOK, "u:" + this.userId1));
        Iterator<FolderObject> iter = listResponse1.getFolder();
        boolean found = false;
        while (iter.hasNext() && !found) {
            if (iter.next().getObjectID() != this.folder.getObjectID()) continue;
            found = true;
        }
        Bug16724Test.assertTrue((String)"Shared folder not found.", (boolean)found);
        GetResponse getResponse1 = this.client2.execute(new GetRequest((API)EnumAPI.OUTLOOK, this.folder.getObjectID()));
        this.folder.setLastModified(getResponse1.getTimestamp());
        this.folder.setPermissionsAsArray(new OCLPermission[]{Create.ocl(this.userId1, false, true, 128, 128, 128, 128)});
        InsertResponse updateResponse = this.client.execute(new UpdateRequest((API)EnumAPI.OUTLOOK, this.folder));
        this.folder.setLastModified(updateResponse.getTimestamp());
        TaskSearchObject search = new TaskSearchObject();
        search.setPattern("");
        SearchResponse searchResponse = this.client2.execute(new SearchRequest(search, new int[]{1, 200}, false));
        Bug16724Test.assertFalse((String)"Search response should not have an error.", (boolean)searchResponse.hasError());
        ListResponse listResponse2 = this.client2.execute(new ListRequest((API)EnumAPI.OUTLOOK, 3));
        iter = listResponse2.getFolder();
        found = false;
        while (iter.hasNext()) {
            if (!iter.next().getFullName().equals("u:" + this.userId1)) continue;
            found = true;
        }
        if (found) {
            listResponse2 = this.client2.execute(new ListRequest((API)EnumAPI.OUTLOOK, "u:" + this.userId1));
            iter = listResponse2.getFolder();
            found = false;
            while (iter.hasNext()) {
                if (iter.next().getObjectID() != this.folder.getObjectID()) continue;
                found = true;
            }
            Bug16724Test.assertFalse((String)"Parent user folder in shared folder should not be there.", (boolean)found);
        }
        ListResponse listResponse3 = this.client2.execute(new ListRequest((API)EnumAPI.OUTLOOK, "u:" + this.userId1));
        iter = listResponse3.getFolder();
        found = false;
        while (iter.hasNext() && !found) {
            if (iter.next().getObjectID() != this.folder.getObjectID()) continue;
            found = true;
        }
        Bug16724Test.assertFalse((String)"Shared folder should not be found.", (boolean)found);
        GetResponse getResponse2 = this.client2.execute(new GetRequest((API)EnumAPI.OUTLOOK, this.folder.getObjectID(), false));
        Bug16724Test.assertTrue((String)"Getting that not shared folder should give a error.", (boolean)getResponse2.hasError());
    }
}

