/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.find.tasks;

import com.openexchange.ajax.find.tasks.AbstractFindTasksTest;
import com.openexchange.ajax.find.tasks.FindTasksTestEnvironment;
import com.openexchange.exception.OXException;
import com.openexchange.find.facet.ActiveFacet;
import com.openexchange.find.facet.FacetType;
import com.openexchange.find.facet.Filter;
import com.openexchange.find.tasks.TasksFacetType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.json.JSONException;
import org.junit.Test;

public class FindTasksTestsFilterCombinations
extends AbstractFindTasksTest {
    public FindTasksTestsFilterCombinations(String name) {
        super(name);
    }

    private static final List<ActiveFacet> getRelevantActiveFacets(char[] combination) {
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        ArrayUtils.reverse((char[])combination);
        for (int i = 0; i < combination.length; ++i) {
            if (combination[i] != '1') continue;
            facets.addAll((Collection<ActiveFacet>)FindTasksTestEnvironment.getInstance().getLoActiveFacets().get(i));
        }
        return facets;
    }

    @Test
    public void testMoreExternalParticipants() throws OXException, IOException, JSONException {
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>(2);
        ArrayList<String> queries = new ArrayList<String>(3);
        queries.add("olox20@premium");
        queries.add("thorben.betten@premium");
        queries.add("x_x_x_x_x_x_x@asdasdasda");
        Filter filter = new Filter(Collections.singletonList("participant"), queries);
        facets.add(new ActiveFacet((FacetType)TasksFacetType.TASK_PARTICIPANTS, "contact/1/464373", filter));
        this.assertResults(0, facets);
    }

    @Test
    public void testWithParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(1).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>(3);
        facets.add(f.get(0));
        this.assertResults(5, facets);
        facets.clear();
        facets.add(f.get(1));
        this.assertResults(4, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        this.assertResults(4, facets);
        facets.clear();
        facets.add(f.get(2));
        facets.add(FindTasksTestEnvironment.createGlobalFacet());
        this.assertResults(2, facets);
        this.assertResults(1, f);
    }

    @Test
    public void testWithStatus() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(2).toCharArray());
        this.assertResults(9, Collections.singletonList(f.get(0)));
        this.assertResults(6, Collections.singletonList(f.get(1)));
        this.assertResults(6, Collections.singletonList(f.get(2)));
        this.assertResults(5, Collections.singletonList(f.get(3)));
        this.assertResults(5, Collections.singletonList(f.get(4)));
    }

    @Test
    public void testWithStatusAndParticipants() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(3).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        this.assertResults(3, facets);
        facets.remove(1);
        facets.add(f.get(4));
        this.assertResults(1, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(3));
        this.assertResults(2, facets);
        facets.remove(2);
        facets.add(f.get(4));
        this.assertResults(1, facets);
        facets.remove(2);
        facets.add(f.get(7));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(2));
        facets.add(f.get(4));
        this.assertResults(1, facets);
        facets.remove(2);
        facets.add(f.get(5));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(4));
        this.assertResults(1, facets);
        facets.remove(3);
        facets.add(f.get(6));
        this.assertResults(0, facets);
    }

    @Test
    public void testWithFolderType() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(4).toCharArray());
        this.assertResults(10, Collections.singletonList(f.get(0)));
        this.assertResults(10, Collections.singletonList(f.get(1)));
        this.assertResults(11, Collections.singletonList(f.get(2)));
    }

    @Test
    public void testWithFolderTypeAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(5).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        this.assertResults(4, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(4));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(5));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(3));
        this.assertResults(3, facets);
        facets.remove(2);
        facets.add(f.get(4));
        this.assertResults(0, facets);
        facets.remove(2);
        facets.add(f.get(5));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(3));
        this.assertResults(1, facets);
        facets.remove(3);
        facets.add(f.get(4));
        this.assertResults(0, facets);
        facets.remove(3);
        facets.add(f.get(5));
        this.assertResults(0, facets);
    }

    @Test
    public void testWithFolderTypeAndStatus() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(6).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(5));
        this.assertResults(4, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(7));
        this.assertResults(3, facets);
        facets.clear();
        facets.add(f.get(1));
        facets.add(f.get(5));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(7));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(2));
        facets.add(f.get(5));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(7));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(3));
        facets.add(f.get(5));
        this.assertResults(1, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(7));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(4));
        facets.add(f.get(5));
        this.assertResults(1, facets);
        facets.remove(1);
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.remove(1);
        facets.add(f.get(7));
        this.assertResults(2, facets);
    }

    @Test
    public void testWithFolderTypeAndStatusAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(7).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        facets.add(f.get(8));
        this.assertResults(2, facets);
        facets.remove(2);
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.remove(2);
        facets.add(f.get(10));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(5));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.remove(2);
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.remove(2);
        facets.add(f.get(10));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(3));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.remove(3);
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.remove(3);
        facets.add(f.get(10));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(5));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.remove(3);
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.remove(3);
        facets.add(f.get(10));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(4));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.remove(4);
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.remove(4);
        facets.add(f.get(10));
        this.assertResults(0, facets);
    }

    @Test
    public void testWithType() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(8).toCharArray());
        this.assertResults(29, Collections.singletonList(f.get(0)), -1, 30);
        this.assertResults(2, Collections.singletonList(f.get(1)));
    }

    @Test
    public void testWithTypeAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(9).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(4));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(3));
        this.assertResults(1, facets);
    }

    @Test
    public void testWithTypeAndStatus() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(10).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(1));
        facets.add(f.get(5));
        this.assertResults(6, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(6));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(4));
        facets.add(f.get(5));
        this.assertResults(5, facets);
    }

    @Test
    public void testWithTypeAndStatusAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(11).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        facets.add(f.get(9));
        this.assertResults(2, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(2));
        facets.add(f.get(3));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(5));
        facets.add(f.get(8));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(7));
        facets.add(f.get(9));
        this.assertResults(0, facets);
    }

    @Test
    public void testWithTypeAndFolderType() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(12).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        this.assertResults(9, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(4));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(1));
        facets.add(f.get(4));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(2));
        facets.add(f.get(4));
        this.assertResults(1, facets);
    }

    @Test
    public void testWithTypeAndFolderTypeAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(13).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        facets.add(f.get(6));
        this.assertResults(3, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(5));
        facets.add(f.get(7));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(4));
        facets.add(f.get(6));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(2));
        facets.add(f.get(3));
        facets.add(f.get(6));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(2));
        facets.add(f.get(3));
        facets.add(f.get(6));
        this.assertResults(2, facets);
    }

    @Test
    public void testWithTypeAndFolderTypeAndStatus() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(14).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(5));
        facets.add(f.get(8));
        this.assertResults(3, facets);
        facets.clear();
        facets.add(f.get(1));
        facets.add(f.get(6));
        facets.add(f.get(9));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(7));
        facets.add(f.get(9));
        this.assertResults(1, facets);
    }

    @Test
    public void testWithTypeAndFolderTypeAndStatusAndParticipant() throws OXException, IOException, JSONException {
        List<ActiveFacet> f = FindTasksTestsFilterCombinations.getRelevantActiveFacets(Integer.toBinaryString(15).toCharArray());
        ArrayList<ActiveFacet> facets = new ArrayList<ActiveFacet>();
        facets.add(f.get(0));
        facets.add(f.get(3));
        facets.add(f.get(8));
        facets.add(f.get(11));
        this.assertResults(1, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(4));
        facets.add(f.get(9));
        facets.add(f.get(11));
        this.assertResults(0, facets);
        facets.clear();
        facets.add(f.get(0));
        facets.add(f.get(1));
        facets.add(f.get(3));
        facets.add(f.get(10));
        facets.add(f.get(12));
        this.assertResults(1, facets);
    }
}

