/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.drive.test;

import com.openexchange.ajax.share.ShareTest;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.FileStorageObjectPermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.folderstorage.Permissions;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import jonelo.jacksum.algorithm.MD;

public abstract class AbstractDriveShareTest
extends ShareTest {
    protected AbstractDriveShareTest(String name) {
        super(name);
    }

    protected void checkFilePermission(int entity, int expectedBits, com.openexchange.file.storage.File file) {
        List objectPermissions = file.getObjectPermissions();
        if (objectPermissions != null) {
            for (FileStorageObjectPermission permission : objectPermissions) {
                if (permission.getEntity() != entity) continue;
                AbstractDriveShareTest.assertEquals((int)expectedBits, (int)permission.getPermissions());
                return;
            }
        }
        AbstractDriveShareTest.fail((String)("Did not find permission for entity " + entity));
    }

    protected void checkFolderPermission(int entity, int expectedBits, FolderObject folder) {
        for (OCLPermission permission : folder.getPermissions()) {
            if (permission.getEntity() != entity) continue;
            AbstractDriveShareTest.assertEquals((int)expectedBits, (int)Permissions.createPermissionBits((int)permission.getFolderPermission(), (int)permission.getReadPermission(), (int)permission.getWritePermission(), (int)permission.getDeletePermission(), (boolean)permission.isFolderAdmin()));
            return;
        }
        AbstractDriveShareTest.fail((String)("Did not find permission for entity " + entity));
    }

    protected String getId(DefaultFile file) {
        FileID fileID = new FileID(file.getId());
        fileID.setFolderId(Integer.toString(10));
        return fileID.toUniqueID();
    }

    protected String getChecksum(File file) throws Exception {
        int read;
        FileInputStream document = new FileInputStream(file);
        byte[] buffer = new byte[2048];
        MD md5 = new MD("MD5");
        do {
            if (0 >= (read = ((InputStream)document).read(buffer))) continue;
            md5.update(buffer, 0, read);
        } while (-1 != read);
        ((InputStream)document).close();
        return md5.getFormattedValue();
    }
}

