/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.drive.action;

import com.openexchange.ajax.drive.action.AbstractDriveRequest;
import com.openexchange.ajax.drive.action.DriveShareWriter;
import com.openexchange.ajax.drive.action.UpdateLinkParser;
import com.openexchange.ajax.drive.action.UpdateLinkResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.drive.DriveShareTarget;
import com.openexchange.xing.util.JSONCoercion;
import java.io.IOException;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateLinkRequest
extends AbstractDriveRequest<UpdateLinkResponse> {
    private boolean failOnError;
    private DriveShareTarget target;
    private Long expiry;
    private String password;
    private Map<String, Object> meta;

    public UpdateLinkRequest(Integer root, DriveShareTarget target, Long timestamp) {
        this(root, target, null, null, null, true);
    }

    public UpdateLinkRequest(Integer root, DriveShareTarget target, Long expiry, String password, Map<String, Object> meta, boolean failOnError) {
        super(root);
        this.target = target;
        this.expiry = expiry;
        this.password = password;
        this.meta = meta;
        this.failOnError = failOnError;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() throws IOException, JSONException {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "updateLink"), new AJAXRequest.Parameter("root", this.root)};
    }

    public UpdateLinkParser getParser() {
        return new UpdateLinkParser(this.failOnError);
    }

    public JSONObject getBody() throws IOException, JSONException {
        JSONObject retval = new JSONObject();
        DriveShareWriter.writeDriveTarget(this.target, retval);
        retval.putOpt("expiry_date", (Object)this.expiry);
        retval.putOpt("meta", null != this.meta ? JSONCoercion.coerceToJSON(this.meta) : null);
        retval.putOpt("password", (Object)this.password);
        return retval;
    }
}

