/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.ContactTest;
import com.openexchange.ajax.contact.action.AutocompleteRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.CommonSearchResponse;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.modules.Module;
import com.openexchange.test.ContactTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Random;
import org.json.JSONArray;

public class UseCountTest
extends ContactTest {
    private AJAXClient client;
    private ContactTestManager ctm;
    private FolderTestManager ftm;
    private MailTestManager mtm;
    private String address;
    private int folderId;

    public UseCountTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.ftm = new FolderTestManager(this.client);
        FolderObject folder = this.ftm.generatePrivateFolder("useCountTest", Module.CONTACTS.getFolderConstant(), this.client.getValues().getPrivateContactFolder(), this.client.getValues().getUserId());
        folder = this.ftm.insertFolderOnServer(folder);
        this.folderId = folder.getObjectID();
        this.ctm = new ContactTestManager(this.client);
        Contact c1 = ContactTestManager.generateContact(folder.getObjectID(), "UseCount");
        c1.setEmail1("useCount1@ox.invalid");
        c1 = this.ctm.newAction(c1);
        Contact c2 = ContactTestManager.generateContact(folder.getObjectID(), "UseCount");
        c2.setEmail1("useCount2@ox.invalid");
        c2 = this.ctm.newAction(c2);
        this.mtm = new MailTestManager(this.client);
        Random rnd = new Random(System.currentTimeMillis());
        this.address = rnd.nextInt() % 2 == 0 ? c1.getEmail1() : c2.getEmail2();
        this.mtm.send(new TestMail(this.client.getValues().getDefaultAddress(), this.address, "Test", "text/plain", "Test"));
    }

    @Override
    public void tearDown() throws Exception {
        this.mtm.cleanUp();
        this.ctm.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }

    public void testUseCount() throws Exception {
        AutocompleteRequest req = new AutocompleteRequest("UseCount", false, String.valueOf(this.folderId), CONTACT_FIELDS, false);
        CommonSearchResponse resp = this.client.execute(req);
        UseCountTest.assertFalse((boolean)resp.hasError());
        JSONArray json = (JSONArray)resp.getData();
        UseCountTest.assertNotNull((Object)json);
        UseCountTest.assertEquals((int)2, (int)json.length());
        Contact[] contacts = UseCountTest.jsonArray2ContactArray(json, CONTACT_FIELDS);
        UseCountTest.assertEquals((String)this.address, (String)contacts[0].getEmail1());
    }
}

