/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.UpdateRequest;
import com.openexchange.ajax.contact.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateNotAllowedFieldsTest
extends AbstractManagedContactTest {
    public UpdateNotAllowedFieldsTest(String name) {
        super(name);
    }

    public void testTryUpdateContextID() throws Exception {
        for (Contact contact : this.getContactsToUpdate()) {
            Contact changedContextID = new Contact();
            changedContextID.setContextId(3465474);
            Contact updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedContextID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"context ID was changed", (int)contact.getContextId(), (int)updatedContact.getContextId());
            changedContextID.setContextId(0);
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedContextID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"context ID was changed", (int)contact.getContextId(), (int)updatedContact.getContextId());
            changedContextID.setContextId(43654754);
            changedContextID.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedContextID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"context ID was changed", (int)contact.getContextId(), (int)updatedContact.getContextId());
        }
    }

    public void testTryUpdateObjectID() throws Exception {
        for (Contact contact : this.getContactsToUpdate()) {
            Contact changedObjectID = new Contact();
            changedObjectID.setObjectID(1533523456);
            Contact updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedObjectID, Category.CATEGORY_PERMISSION_DENIED);
            UpdateNotAllowedFieldsTest.assertEquals((String)"object ID was changed", (int)contact.getObjectID(), (int)updatedContact.getObjectID());
            changedObjectID.setObjectID(0);
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedObjectID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"object ID was changed", (int)contact.getObjectID(), (int)updatedContact.getObjectID());
            changedObjectID.setObjectID(8794);
            changedObjectID.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedObjectID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"object ID was changed", (int)contact.getObjectID(), (int)updatedContact.getObjectID());
        }
    }

    public void testTryUpdateUserID() throws Exception {
        for (Contact contact : this.getContactsToUpdate()) {
            Contact changedUserID = new Contact();
            changedUserID.setInternalUserId(23235235);
            Contact updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedUserID, Category.CATEGORY_PERMISSION_DENIED);
            UpdateNotAllowedFieldsTest.assertEquals((String)"user ID was changed", (int)contact.getInternalUserId(), (int)updatedContact.getInternalUserId());
            changedUserID.setInternalUserId(0);
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedUserID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"user ID was changed", (int)contact.getInternalUserId(), (int)updatedContact.getInternalUserId());
            changedUserID.setInternalUserId(45600);
            changedUserID.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedUserID, Category.CATEGORY_PERMISSION_DENIED);
            UpdateNotAllowedFieldsTest.assertEquals((String)"user ID was changed", (int)contact.getInternalUserId(), (int)updatedContact.getInternalUserId());
        }
    }

    public void testTryUpdateUID() throws Exception {
        for (Contact contact : this.getContactsToUpdate()) {
            Contact changedUID = new Contact();
            changedUID.setUid(UUID.randomUUID().toString());
            Contact updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), contact.getLastModified().getTime(), changedUID, Category.CATEGORY_PERMISSION_DENIED);
            UpdateNotAllowedFieldsTest.assertEquals((String)"UID was changed", (String)contact.getUid(), (String)updatedContact.getUid());
            changedUID.setUid(null);
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedUID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"UID was changed", (String)contact.getUid(), (String)updatedContact.getUid());
            changedUID.setUid("");
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedUID, null);
            UpdateNotAllowedFieldsTest.assertEquals((String)"UID was changed", (String)contact.getUid(), (String)updatedContact.getUid());
            changedUID.setUid(UUID.randomUUID().toString());
            changedUID.setParentFolderID(this.getClient().getValues().getPrivateContactFolder());
            updatedContact = this.tryToUpdate(contact.getObjectID(), contact.getParentFolderID(), updatedContact.getLastModified().getTime(), changedUID, Category.CATEGORY_PERMISSION_DENIED);
            UpdateNotAllowedFieldsTest.assertEquals((String)"UID was changed", (String)contact.getUid(), (String)updatedContact.getUid());
        }
    }

    private Contact tryToUpdate(int objectID, int folderID, long timestamp, Contact changes, Category expectedExceptionCategory) throws Exception {
        DeltaUpdateRequest updateRequest = new DeltaUpdateRequest(objectID, folderID, timestamp, changes, false);
        UpdateResponse updateResponse = super.getClient().execute(updateRequest);
        UpdateNotAllowedFieldsTest.assertNotNull((String)"got no response", (Object)((Object)updateResponse));
        if (null != expectedExceptionCategory) {
            OXException exception = updateResponse.getException();
            UpdateNotAllowedFieldsTest.assertNotNull((String)"got no exception", (Object)((Object)exception));
            UpdateNotAllowedFieldsTest.assertEquals((String)"unexpected exception category", (Object)expectedExceptionCategory, (Object)exception.getCategory());
        }
        return this.manager.getAction(folderID, objectID);
    }

    private Contact[] getContactsToUpdate() throws Exception {
        return new Contact[]{this.client.execute(new GetRequest(this.client.getValues().getUserId(), this.client.getValues().getTimeZone())).getContact(), this.manager.getAction(this.manager.newAction(this.generateContact()))};
    }

    private static class DeltaUpdateRequest
    extends UpdateRequest {
        private final int objectID;
        private final int folderID;
        private final long timestamp;

        public DeltaUpdateRequest(int objectID, int folderID, long timestamp, Contact changes, boolean failOnErrors) {
            super(folderID, changes, failOnErrors);
            this.objectID = objectID;
            this.folderID = folderID;
            this.timestamp = timestamp;
        }

        @Override
        public AJAXRequest.Parameter[] getParameters() {
            return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("folder", String.valueOf(this.folderID)), new AJAXRequest.Parameter("id", String.valueOf(this.objectID)), new AJAXRequest.Parameter("timestamp", String.valueOf(this.timestamp))};
        }

        @Override
        public Object getBody() throws JSONException {
            Contact contact = super.getContact();
            JSONObject jsonObject = this.convert(contact);
            if (contact.containsContextId()) {
                jsonObject.put("cid", contact.getContextId());
            }
            if (contact.containsUid()) {
                jsonObject.put("uid", null == contact.getUid() ? JSONObject.NULL : contact.getUid());
            }
            return jsonObject;
        }
    }
}

