/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractContactTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.ListRequest;
import com.openexchange.ajax.framework.CommonListResponse;
import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.ArrayList;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class ListTest
extends AbstractContactTest {
    public ListTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testList() throws Exception {
        Contact contactObj = this.createContactObject("testList");
        int id1 = this.insertContact(contactObj);
        int id2 = this.insertContact(contactObj);
        int id3 = this.insertContact(contactObj);
        Thread.sleep(1000L);
        int[][] objectIdAndFolderId = new int[][]{{id3, this.contactFolderId}, {id2, this.contactFolderId}, {id1, this.contactFolderId}};
        int[] cols = new int[]{1, 502, 500, 20};
        Contact[] contactArray = this.listContact(objectIdAndFolderId, cols);
        ListTest.assertEquals((String)"check response array", (int)3, (int)contactArray.length);
        for (int i = 0; i < contactArray.length; ++i) {
            int[] ids = objectIdAndFolderId[i];
            ListTest.assertTrue((String)"Returned contacts object id differs from the requested one.", (ids[0] == contactArray[i].getObjectID() ? 1 : 0) != 0);
            ListTest.assertTrue((String)"Returned contacts folder id differs from the requested one.", (ids[1] == contactArray[i].getParentFolderID() ? 1 : 0) != 0);
        }
    }

    public void testSortDuration() throws Exception {
        int size = 10000;
        ArrayList<Contact> contacts = new ArrayList<Contact>();
        int[][] objectIdsAndFolderIds = new int[10000][2];
        for (int i = 0; i < 10000; ++i) {
            int objectId = 9999 - i;
            Contact contact = this.createContactObject("testList");
            contact.setObjectID(objectId);
            contacts.add(contact);
            objectIdsAndFolderIds[i] = new int[]{i, this.contactFolderId};
        }
        long start = System.currentTimeMillis();
        ArrayList<Contact> sortedContacts = new ArrayList<Contact>(contacts.size());
        block1: for (int i = 0; i < objectIdsAndFolderIds.length; ++i) {
            int[] objectIdsAndFolderId = objectIdsAndFolderIds[i];
            int objectId = objectIdsAndFolderId[0];
            int folderId = objectIdsAndFolderId[1];
            for (Contact contact : contacts) {
                if (contact.getObjectID() != objectId || contact.getParentFolderID() != folderId) continue;
                sortedContacts.add(contact);
                continue block1;
            }
        }
        long end = System.currentTimeMillis();
        long diff = end - start;
    }

    public void testListWithAllFields() throws Exception {
        Contact contactObject = this.createCompleteContactObject();
        int objectId = this.insertContact(contactObject);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.contactFolderId}};
        Contact[] contactArray = this.listContact(objectIdAndFolderId, CONTACT_FIELDS);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        Contact loadContact = contactArray[0];
        contactObject.setObjectID(objectId);
        this.compareObject(contactObject, loadContact);
    }

    public void testListWithNotExistingEntries() throws Exception {
        Contact contactObject = this.createCompleteContactObject();
        int objectId = this.insertContact(contactObject);
        contactObject.setDisplayName(UUID.randomUUID().toString());
        int objectId2 = this.insertContact(contactObject);
        int[] cols = new int[]{1, 502, 500};
        int[][] objectIdAndFolderId1 = new int[][]{{objectId, this.contactFolderId}, {objectId + 100, this.contactFolderId}};
        Contact[] contactArray = this.listContact(objectIdAndFolderId1, cols);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        int[][] objectIdAndFolderId2 = new int[][]{{objectId + 100, this.contactFolderId}, {objectId, this.contactFolderId}};
        contactArray = this.listContact(objectIdAndFolderId2, cols);
        ListTest.assertEquals((String)"check response array", (int)1, (int)contactArray.length);
        int[][] objectIdAndFolderId3 = new int[][]{{objectId + 100, this.contactFolderId}, {objectId, this.contactFolderId}, {objectId2, this.contactFolderId}};
        contactArray = this.listContact(objectIdAndFolderId3, cols);
        ListTest.assertEquals((String)"check response array", (int)2, (int)contactArray.length);
        this.deleteContact(objectId, this.contactFolderId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLastModifiedUTC() throws Exception {
        int[] cols = new int[]{1, 20, 6};
        Contact contactObj = this.createContactObject("testLastModifiedUTC");
        int objectId = this.insertContact(contactObj);
        try {
            ListRequest listRequest = new ListRequest(ListIDs.l(new int[][]{{this.contactFolderId, objectId}}), cols, true);
            CommonListResponse response = Executor.execute(this.client, listRequest);
            JSONArray arr = (JSONArray)response.getResponse().getData();
            ListTest.assertNotNull((Object)arr);
            int size = arr.length();
            ListTest.assertTrue((size > 0 ? 1 : 0) != 0);
            for (int i = 0; i < size; ++i) {
                JSONArray objectData = arr.optJSONArray(i);
                ListTest.assertNotNull((Object)objectData);
                ListTest.assertNotNull((Object)objectData.opt(2));
            }
        }
        finally {
            this.deleteContact(objectId, this.contactFolderId, true);
        }
    }

    protected Contact createContactWithDistList(Contact contactEntry) throws Exception {
        Contact contactObj = new Contact();
        String string = UUID.randomUUID().toString();
        contactObj.setSurName(string);
        contactObj.setParentFolderID(this.contactFolderId);
        contactObj.setDisplayName(string);
        DistributionListEntryObject[] entry = new DistributionListEntryObject[]{new DistributionListEntryObject(contactEntry.getDisplayName(), contactEntry.getEmail1(), 1)};
        entry[0].setEntryID(contactEntry.getObjectID());
        contactObj.setDistributionList(entry);
        this.insertContact(contactObj);
        return contactObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42726_emptyList_markedAsDistList() throws Exception {
        Contact contactEntry = this.createContactObject("internal contact");
        contactEntry.setEmail1("internalcontact@x.de");
        int contactId = this.insertContact(contactEntry);
        int distListObjectId = 0;
        try {
            contactEntry.setObjectID(contactId);
            Contact distList = this.createContactWithDistList(contactEntry);
            distListObjectId = distList.getObjectID();
            GetRequest getRequest = new GetRequest(this.contactFolderId, distListObjectId, this.tz, false);
            GetResponse getResponse = this.client.execute(getRequest);
            Boolean markAsDistList = new Boolean(((JSONObject)getResponse.getData()).getBoolean("mark_as_distributionlist"));
            ListTest.assertTrue((boolean)markAsDistList);
            Long numberOfDistListMembers = ((JSONObject)getResponse.getData()).getLong("number_of_distribution_list");
            ListTest.assertTrue((numberOfDistListMembers == 1L ? 1 : 0) != 0);
            JSONArray distListArray = ((JSONObject)getResponse.getData()).getJSONArray("distribution_list");
            ListTest.assertTrue(((long)distListArray.length() == numberOfDistListMembers ? 1 : 0) != 0);
            distList.setDistributionList(new DistributionListEntryObject[0]);
            this.updateContact(distList, this.contactFolderId);
            GetRequest emptyGetRequest = new GetRequest(this.contactFolderId, distListObjectId, this.tz, false);
            GetResponse emptyGetResponse = this.client.execute(emptyGetRequest);
            Boolean emptyMarkAsDistList = new Boolean(((JSONObject)emptyGetResponse.getData()).getBoolean("mark_as_distributionlist"));
            ListTest.assertTrue((String)"Contact not marked as list", (boolean)emptyMarkAsDistList);
            Long emptyNumberOfDistListMembers = ((JSONObject)emptyGetResponse.getData()).getLong("number_of_distribution_list");
            ListTest.assertTrue((String)"Empty list has wrong number of members", (emptyNumberOfDistListMembers == 0L ? 1 : 0) != 0);
        }
        finally {
            this.deleteContact(contactId, this.contactFolderId, true);
            this.deleteContact(distListObjectId, this.contactFolderId, true);
        }
    }
}

