/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import com.openexchange.java.util.UUIDs;
import java.util.Comparator;
import java.util.UUID;

public class Bug35059Test
extends AbstractManagedContactTest {
    public Bug35059Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testSortOrder() throws Exception {
        DistributionListEntryObject[] distributionList = new DistributionListEntryObject[100];
        for (int i = 0; i < 100; ++i) {
            DistributionListEntryObject member = new DistributionListEntryObject();
            member.setEmailaddress(UUIDs.getUnformattedString((UUID)UUID.randomUUID()) + "@example.com");
            if (0 == i % 2) {
                member.setDisplayname(UUIDs.getUnformattedString((UUID)UUID.randomUUID()));
            }
            distributionList[i] = member;
        }
        Contact contact = super.generateContact("List");
        contact.setDistributionList(distributionList);
        contact = this.manager.newAction(contact);
        GetResponse response = this.client.execute(new GetRequest(contact, this.client.getValues().getTimeZone()));
        contact = response.getContact();
        DistributionListEntryObject[] list = contact.getDistributionList();
        Bug35059Test.assertNotNull((String)"No distribution list", (Object)list);
        Bug35059Test.assertEquals((String)"Wrong number of members", (int)distributionList.length, (int)list.length);
        Comparator<DistributionListEntryObject> comparator = new Comparator<DistributionListEntryObject>(){

            @Override
            public int compare(DistributionListEntryObject o1, DistributionListEntryObject o2) {
                String name1 = null == o1.getDisplayname() ? o1.getEmailaddress() : o1.getDisplayname() + o1.getEmailaddress();
                String name2 = null == o2.getDisplayname() ? o2.getEmailaddress() : o2.getDisplayname() + o2.getEmailaddress();
                return name1.compareTo(name2);
            }
        };
        for (int i = 0; i < list.length - 1; ++i) {
            DistributionListEntryObject smallerMember = list[i];
            DistributionListEntryObject biggerMember = list[i + 1];
            Bug35059Test.assertTrue((String)("Wrong sort order: " + smallerMember + " appears before " + biggerMember), (0 >= comparator.compare(smallerMember, biggerMember) ? 1 : 0) != 0);
        }
    }
}

