/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.AutocompleteRequest;
import com.openexchange.ajax.framework.CommonSearchResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DistributionListEntryObject;
import java.util.List;
import org.json.JSONArray;

public class AutocompleteTest
extends AbstractManagedContactTest {
    public AutocompleteTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testAutocompleteFirstAndLastname() throws Exception {
        String[] queries;
        Contact contact = super.generateContact("Otto");
        contact.setGivenName("Heinz");
        contact.setDisplayName("Otto, Heinz");
        contact = this.manager.newAction(contact);
        String parentFolderID = String.valueOf(contact.getParentFolderID());
        for (String query : queries = new String[]{"Otto", "Heinz", "Heinz Otto", "\"Otto, Heinz\""}) {
            AutocompleteRequest request = new AutocompleteRequest(query, false, parentFolderID, Contact.ALL_COLUMNS, true);
            CommonSearchResponse response = this.client.execute(request);
            List<Contact> contacts = this.manager.transform((JSONArray)response.getResponse().getData(), Contact.ALL_COLUMNS);
            AutocompleteTest.assertNotNull(contacts);
            AutocompleteTest.assertEquals((String)"wrong number of results", (int)1, (int)contacts.size());
            AutocompleteTest.assertEquals((String)contact.getDisplayName(), (String)contacts.get(0).getDisplayName());
        }
    }

    public void testAutocompleteSpecificContact() throws Exception {
        Contact contact = super.generateContact("Otto");
        contact.setGivenName("Heinz");
        contact.setDisplayName("Otto, Heinz");
        contact = this.manager.newAction(contact);
        Contact contact2 = super.generateContact("Otto");
        contact2.setGivenName("Horst");
        contact2.setDisplayName("Otto, Horst");
        contact2 = this.manager.newAction(contact2);
        Contact contact3 = super.generateContact("Wurst");
        contact3.setGivenName("Heinz");
        contact3.setDisplayName("Wurst, Heinz");
        contact3 = this.manager.newAction(contact3);
        String parentFolderID = String.valueOf(contact.getParentFolderID());
        AutocompleteRequest request = new AutocompleteRequest("Heinz Otto", false, parentFolderID, Contact.ALL_COLUMNS, true);
        CommonSearchResponse response = this.client.execute(request);
        List<Contact> contacts = this.manager.transform((JSONArray)response.getResponse().getData(), Contact.ALL_COLUMNS);
        AutocompleteTest.assertNotNull(contacts);
        AutocompleteTest.assertEquals((String)"wrong number of results", (int)1, (int)contacts.size());
        AutocompleteTest.assertEquals((String)contact.getDisplayName(), (String)contacts.get(0).getDisplayName());
    }

    public void testAutocompleteDistributionList() throws Exception {
        Contact distributionList = new Contact();
        distributionList.setParentFolderID(this.folderID);
        distributionList.setSurName("LisTe");
        distributionList.setGivenName("VerTeiLer");
        distributionList.setDisplayName(distributionList.getGivenName() + " " + distributionList.getSurName());
        distributionList.setDistributionList(new DistributionListEntryObject[]{new DistributionListEntryObject("displayname a", "a@a.de", 0), new DistributionListEntryObject("displayname b", "b@b.de", 0)});
        distributionList = this.manager.newAction(distributionList);
        AutocompleteRequest request = new AutocompleteRequest(distributionList.getGivenName(), false, Integer.toString(this.folderID), Contact.ALL_COLUMNS, true);
        CommonSearchResponse response = this.client.execute(request);
        List<Contact> contacts = this.manager.transform((JSONArray)response.getResponse().getData(), Contact.ALL_COLUMNS);
        AutocompleteTest.assertNotNull(contacts);
        AutocompleteTest.assertEquals((String)"wrong number of results", (int)1, (int)contacts.size());
        AutocompleteTest.assertEquals((String)distributionList.getDisplayName(), (String)contacts.get(0).getDisplayName());
    }
}

