/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.config;

import com.openexchange.ajax.config.AttributeWriter;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.java.Autoboxing;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BetaWriter
extends AttributeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BetaWriter.class);
    private final Random rand = new Random(System.currentTimeMillis());
    private final boolean ignoreConcurrentModification;

    public BetaWriter(AJAXClient.User user) {
        this(user, false);
    }

    public BetaWriter(AJAXClient.User user, boolean ignoreConcurrentModification) {
        super(Tree.Beta, user);
        this.ignoreConcurrentModification = ignoreConcurrentModification;
    }

    @Override
    protected Object getValue() {
        return Autoboxing.B((boolean)this.rand.nextBoolean());
    }

    @Override
    protected Throwable handleError(Throwable t) {
        if (this.ignoreConcurrentModification && t instanceof OXException && UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.equals((OXException)t)) {
            LOG.warn(t.getMessage());
            return null;
        }
        return t;
    }
}

