/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.attach;

import com.openexchange.ajax.attach.actions.AttachRequest;
import com.openexchange.ajax.attach.actions.GetDocumentRequest;
import com.openexchange.ajax.attach.actions.GetDocumentResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Bug30701Test {
    private AJAXClient client;
    private Contact contactA;
    private int folderID;
    private int attachmentID;
    private TimeZone tz;

    @Before
    public void setUp() throws Exception {
        this.client = new AJAXClient(AJAXClient.User.User1);
        this.folderID = this.client.getValues().getPrivateContactFolder();
        this.tz = this.client.getValues().getTimeZone();
        this.contactA = new Contact();
        this.contactA.setGivenName("Test");
        this.contactA.setMiddleName("for");
        this.contactA.setSurName("Bug 30701");
        this.contactA.setDisplayName("Test for bug 30701");
        this.contactA.setParentFolderID(this.folderID);
        this.client.execute(new InsertRequest(this.contactA)).fillObject((DataObject)this.contactA);
        ByteArrayInputStream data = new ByteArrayInputStream("Test document with arbitrary data".getBytes());
        this.attachmentID = this.client.execute(new AttachRequest((CommonObject)this.contactA, "doc.txt", data, "text/plain")).getId();
        this.contactA = this.client.execute(new GetRequest(this.contactA, this.tz)).getContact();
        this.contactA.getLastModifiedOfNewestAttachment().getTime();
    }

    @After
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contactA));
        this.client.logout();
    }

    @Test
    public void testGetDocumentWithOffLenParameter() throws OXException, IOException, JSONException {
        int length = 8;
        GetDocumentRequest getDocReq = new GetDocumentRequest((CommonObject)this.contactA, 7, "text/plain", this.folderID, this.attachmentID, 5, 8, true);
        GetDocumentResponse getDocResp = this.client.execute(getDocReq);
        Assert.assertEquals((String)"Wrong Content-Length in response", (long)8L, (long)getDocResp.getContentLength());
    }
}

