/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.appointment.action.UpdateRequest;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.folder.Create;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.json.JSONException;
import org.xml.sax.SAXException;

public final class Bug12595Test
extends AbstractAJAXSession {
    private AJAXClient boss;
    private AJAXClient secretary;
    private AJAXClient thirdUser;
    private TimeZone secTZ;
    private FolderObject sharedFolder;
    private Appointment series;
    private Appointment exception;

    public Bug12595Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.boss = this.getClient();
        this.secretary = new AJAXClient(AJAXClient.User.User2);
        this.thirdUser = new AJAXClient(AJAXClient.User.User3);
        this.secTZ = this.secretary.getValues().getTimeZone();
        this.sharePrivateFolder();
        this.createSeries();
        this.createException();
    }

    @Override
    protected void tearDown() throws Exception {
        this.deleteSeries();
        this.unsharePrivateFolder();
        this.thirdUser.logout();
        this.secretary.logout();
        super.tearDown();
    }

    public void testFindException() throws Throwable {
        com.openexchange.ajax.appointment.action.GetRequest request = new com.openexchange.ajax.appointment.action.GetRequest(this.sharedFolder.getObjectID(), this.exception.getObjectID(), false);
        com.openexchange.ajax.appointment.action.GetResponse response = this.boss.execute(request);
        Bug12595Test.assertFalse((String)"Change exception get lost.", (boolean)response.hasError());
    }

    private void sharePrivateFolder() throws OXException, IOException, SAXException, JSONException {
        this.sharedFolder = new FolderObject(this.boss.getValues().getPrivateAppointmentFolder());
        this.sharedFolder.setModule(2);
        GetRequest request = new GetRequest((API)EnumAPI.OX_OLD, this.sharedFolder.getObjectID(), new int[]{5});
        GetResponse response = this.boss.execute(request);
        this.sharedFolder.setLastModified(response.getTimestamp());
        OCLPermission perm1 = Create.ocl(this.boss.getValues().getUserId(), false, true, 128, 128, 128, 128);
        OCLPermission perm2 = Create.ocl(this.secretary.getValues().getUserId(), false, false, 128, 128, 128, 128);
        this.sharedFolder.setPermissionsAsArray(new OCLPermission[]{perm1, perm2});
        com.openexchange.ajax.folder.actions.UpdateRequest request2 = new com.openexchange.ajax.folder.actions.UpdateRequest((API)EnumAPI.OX_OLD, this.sharedFolder);
        CommonInsertResponse response2 = this.boss.execute(request2);
        this.sharedFolder.setLastModified(response2.getTimestamp());
    }

    private void createSeries() throws OXException, IOException, SAXException, JSONException {
        this.series = new Appointment();
        this.series.setParentFolderID(this.sharedFolder.getObjectID());
        this.series.setTitle("test for bug 12595");
        Calendar calendar = TimeTools.createCalendar(this.secTZ);
        this.series.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        this.series.setEndDate(calendar.getTime());
        this.series.setRecurrenceType(1);
        this.series.setInterval(1);
        this.series.setOccurrence(2);
        this.series.setParticipants(new Participant[]{new UserParticipant(this.boss.getValues().getUserId()), new UserParticipant(this.secretary.getValues().getUserId()), new UserParticipant(this.thirdUser.getValues().getUserId())});
        this.series.setIgnoreConflicts(true);
        InsertRequest request = new InsertRequest(this.series, this.secTZ);
        AppointmentInsertResponse response = this.secretary.execute(request);
        this.series.setObjectID(response.getId());
        this.series.setLastModified(response.getTimestamp());
    }

    private void createException() throws OXException, IOException, SAXException, JSONException, OXException {
        com.openexchange.ajax.appointment.action.GetRequest request = new com.openexchange.ajax.appointment.action.GetRequest(this.sharedFolder.getObjectID(), this.series.getObjectID(), 2);
        com.openexchange.ajax.appointment.action.GetResponse response = this.secretary.execute(request);
        Appointment occurrence = response.getAppointment(this.secTZ);
        this.exception = new Appointment();
        this.exception.setParentFolderID(this.sharedFolder.getObjectID());
        this.exception.setObjectID(occurrence.getObjectID());
        this.exception.setRecurrencePosition(occurrence.getRecurrencePosition());
        this.exception.setTitle("test for bug 12595 changed");
        this.exception.setLastModified(occurrence.getLastModified());
        Calendar calendar = TimeTools.createCalendar(this.secTZ);
        calendar.setTime(occurrence.getEndDate());
        this.exception.setStartDate(calendar.getTime());
        calendar.add(11, 1);
        this.exception.setEndDate(calendar.getTime());
        this.exception.setParticipants(new Participant[]{new UserParticipant(this.boss.getValues().getUserId()), new UserParticipant(this.secretary.getValues().getUserId())});
        this.exception.setIgnoreConflicts(true);
        UpdateRequest request2 = new UpdateRequest(this.exception, this.secTZ);
        UpdateResponse response2 = this.secretary.execute(request2);
        this.exception.setLastModified(response2.getTimestamp());
        this.exception.setObjectID(response2.getId());
    }

    private void deleteSeries() throws OXException, IOException, SAXException, JSONException {
        com.openexchange.ajax.appointment.action.GetRequest request = new com.openexchange.ajax.appointment.action.GetRequest(this.series.getParentFolderID(), this.series.getObjectID());
        com.openexchange.ajax.appointment.action.GetResponse response = this.secretary.execute(request);
        DeleteRequest request2 = new DeleteRequest(this.series.getObjectID(), this.series.getParentFolderID(), response.getTimestamp());
        this.secretary.execute(request2);
    }

    private void unsharePrivateFolder() throws OXException, IOException, SAXException, JSONException {
        OCLPermission perm1 = Create.ocl(this.boss.getValues().getUserId(), false, true, 128, 128, 128, 128);
        this.sharedFolder.setPermissionsAsArray(new OCLPermission[]{perm1});
        com.openexchange.ajax.folder.actions.UpdateRequest request = new com.openexchange.ajax.folder.actions.UpdateRequest((API)EnumAPI.OX_OLD, this.sharedFolder);
        CommonInsertResponse response = this.boss.execute(request);
        this.sharedFolder.setLastModified(response.getTimestamp());
    }
}

