/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;

public class Bug41995Test
extends AbstractAJAXSession {
    private AJAXClient client2;
    private CalendarTestManager ctm1;
    private CalendarTestManager ctm2;
    private Appointment appointment;
    private String origtz1;
    private String origtz2;

    public Bug41995Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm1 = new CalendarTestManager(this.client);
        this.ctm1.setFailOnError(true);
        this.ctm2 = new CalendarTestManager(this.client2);
        this.ctm2.setFailOnError(true);
        GetRequest getRequest = new GetRequest(Tree.TimeZone);
        GetResponse getResponse = this.client.execute(getRequest);
        this.origtz1 = getResponse.getString();
        getRequest = new GetRequest(Tree.TimeZone);
        getResponse = this.client.execute(getRequest);
        this.origtz2 = getResponse.getString();
        SetRequest setRequest = new SetRequest(Tree.TimeZone, "America/New_York");
        this.client.execute(setRequest);
        setRequest = new SetRequest(Tree.TimeZone, "Europe/Berlin");
        this.client2.execute(setRequest);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 41995 Test");
        this.appointment.setStartDate(TimeTools.D("01.11.2016 07:00"));
        this.appointment.setEndDate(TimeTools.D("01.11.2016 08:00"));
        this.appointment.setRecurrenceType(2);
        this.appointment.setInterval(1);
        this.appointment.setDays(4);
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setParticipants(new Participant[]{new UserParticipant(this.client.getValues().getUserId()), new UserParticipant(this.client2.getValues().getUserId())});
        this.ctm1.insert(this.appointment);
    }

    public void testBug41995() throws Exception {
        Appointment update = new Appointment();
        update.setObjectID(this.appointment.getObjectID());
        update.setLastModified(new Date(Long.MAX_VALUE));
        update.setParentFolderID(this.client2.getValues().getPrivateAppointmentFolder());
        update.setAlarm(15);
        this.ctm2.update(update);
        Appointment loaded = this.ctm1.get(this.client.getValues().getPrivateAppointmentFolder(), this.appointment.getObjectID());
        Bug41995Test.assertEquals((String)"Wrong start date.", (Object)this.appointment.getStartDate(), (Object)loaded.getStartDate());
        Bug41995Test.assertEquals((String)"Wrong end date.", (Object)this.appointment.getEndDate(), (Object)loaded.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        SetRequest setRequest = new SetRequest(Tree.TimeZone, this.origtz1);
        this.client.execute(setRequest);
        setRequest = new SetRequest(Tree.TimeZone, this.origtz2);
        this.client2.execute(setRequest);
        this.ctm1.cleanUp();
        this.ctm2.cleanUp();
        super.tearDown();
    }
}

