/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.config.actions.GetRequest;
import com.openexchange.ajax.config.actions.GetResponse;
import com.openexchange.ajax.config.actions.SetRequest;
import com.openexchange.ajax.config.actions.Tree;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.io.IOException;
import java.util.TimeZone;
import org.json.JSONException;

public class Bug38079Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private Appointment appointment;
    private String origTimeZone;

    public Bug38079Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        GetRequest getRequest = new GetRequest(Tree.TimeZone);
        GetResponse getResponse = this.getClient().execute(getRequest);
        this.origTimeZone = getResponse.getString();
        this.ctm = new CalendarTestManager(this.client);
        this.appointment = new Appointment();
        this.appointment.setTitle("Bug 38079 Test");
        this.appointment.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.appointment.setRecurrenceType(4);
        this.appointment.setInterval(1);
        this.appointment.setDayInMonth(16);
        this.appointment.setIgnoreConflicts(true);
    }

    public void testAmericaNewYork_JAN() throws Exception {
        this.runTest("America/New_York", 0);
    }

    public void testEuropeBerlin_JAN() throws Exception {
        this.runTest("Europe/Berlin", 0);
    }

    public void testAfricaBanjul_JAN() throws Exception {
        this.runTest("Africa/Banjul", 0);
    }

    public void testAmericaNewYork_FEB() throws Exception {
        this.runTest("America/New_York", 1);
    }

    public void testEuropeBerlin_FEB() throws Exception {
        this.runTest("Europe/Berlin", 1);
    }

    public void testAfricaBanjul_FEB() throws Exception {
        this.runTest("Africa/Banjul", 1);
    }

    public void testAmericaNewYork_MAR() throws Exception {
        this.runTest("America/New_York", 2);
    }

    public void testEuropeBerlin_MAR() throws Exception {
        this.runTest("Europe/Berlin", 2);
    }

    public void testAfricaBanjul_MAR() throws Exception {
        this.runTest("Africa/Banjul", 2);
    }

    public void testAmericaNewYork_APR() throws Exception {
        this.runTest("America/New_York", 3);
    }

    public void testEuropeBerlin_APR() throws Exception {
        this.runTest("Europe/Berlin", 3);
    }

    public void testAfricaBanjul_APR() throws Exception {
        this.runTest("Africa/Banjul", 3);
    }

    public void testAmericaNewYork_MAY() throws Exception {
        this.runTest("America/New_York", 4);
    }

    public void testEuropeBerlin_MAY() throws Exception {
        this.runTest("Europe/Berlin", 4);
    }

    public void testAfricaBanjul_MAY() throws Exception {
        this.runTest("Africa/Banjul", 4);
    }

    public void testAmericaNewYork_JUN() throws Exception {
        this.runTest("America/New_York", 5);
    }

    public void testEuropeBerlin_JUN() throws Exception {
        this.runTest("Europe/Berlin", 5);
    }

    public void testAfricaBanjul_JUN() throws Exception {
        this.runTest("Africa/Banjul", 5);
    }

    public void testAmericaNewYork_JUL() throws Exception {
        this.runTest("America/New_York", 6);
    }

    public void testEuropeBerlin_JUL() throws Exception {
        this.runTest("Europe/Berlin", 6);
    }

    public void testAfricaBanjul_JUL() throws Exception {
        this.runTest("Africa/Banjul", 6);
    }

    public void testAmericaNewYork_AUG() throws Exception {
        this.runTest("America/New_York", 7);
    }

    public void testEuropeBerlin_AUG() throws Exception {
        this.runTest("Europe/Berlin", 7);
    }

    public void testAfricaBanjul_AUG() throws Exception {
        this.runTest("Africa/Banjul", 7);
    }

    public void testAmericaNewYork_SEP() throws Exception {
        this.runTest("America/New_York", 8);
    }

    public void testEuropeBerlin_SEP() throws Exception {
        this.runTest("Europe/Berlin", 8);
    }

    public void testAfricaBanjul_SEP() throws Exception {
        this.runTest("Africa/Banjul", 8);
    }

    public void testAmericaNewYork_OCT() throws Exception {
        this.runTest("America/New_York", 9);
    }

    public void testEuropeBerlin_OCT() throws Exception {
        this.runTest("Europe/Berlin", 9);
    }

    public void testAfricaBanjul_OCT() throws Exception {
        this.runTest("Africa/Banjul", 9);
    }

    public void testAmericaNewYork_NOV() throws Exception {
        this.runTest("America/New_York", 10);
    }

    public void testEuropeBerlin_NOV() throws Exception {
        this.runTest("Europe/Berlin", 10);
    }

    public void testAfricaBanjul_NOV() throws Exception {
        this.runTest("Africa/Banjul", 10);
    }

    public void testAmericaNewYork_DEC() throws Exception {
        this.runTest("America/New_York", 11);
    }

    public void testEuropeBerlin_DEC() throws Exception {
        this.runTest("Europe/Berlin", 11);
    }

    public void testAfricaBanjul_DEC() throws Exception {
        this.runTest("Africa/Banjul", 11);
    }

    private void runTest(String tzId, int month) throws OXException, IOException, JSONException {
        TimeZone tz = TimeZone.getTimeZone(tzId);
        SetRequest setRequest = new SetRequest(Tree.TimeZone, tz.getID());
        this.getClient().execute(setRequest);
        this.appointment.setMonth(month);
        this.appointment.setStartDate(TimeTools.D("05.05.2015 08:00", tz));
        this.appointment.setEndDate(TimeTools.D("05.05.2015 09:00", tz));
        this.ctm.setTimezone(tz);
        this.ctm.insert(this.appointment);
        int year = 2015;
        if (month < 4) {
            ++year;
        }
        Appointment loadedAppointment = this.ctm.get(this.appointment.getParentFolderID(), this.appointment.getObjectID());
        Bug38079Test.assertEquals((String)("Wrong start for month " + (month + 1)), (Object)TimeTools.D("16." + (month + 1) + "." + year + " 08:00", tz), (Object)loadedAppointment.getStartDate());
        Bug38079Test.assertEquals((String)("Wrong end for month " + (month + 1)), (Object)TimeTools.D("16." + (month + 1) + "." + year + " 09:00", tz), (Object)loadedAppointment.getEndDate());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        SetRequest setRequest = new SetRequest(Tree.TimeZone, this.origTimeZone);
        this.getClient().execute(setRequest);
        super.tearDown();
    }
}

