/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.ListIDs;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.test.CalendarTestManager;
import com.openexchange.test.FolderTestManager;
import java.util.Calendar;
import java.util.List;

public class Bug35687Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private FolderTestManager ftm;
    private AJAXClient client2;
    private FolderObject folder;
    private Appointment app;

    public Bug35687Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client2 = new AJAXClient(AJAXClient.User.User2);
        this.ctm = new CalendarTestManager(this.client);
        this.ftm = new FolderTestManager(this.client);
        this.folder = this.ftm.generateSharedFolder("Bug35687Folder" + System.currentTimeMillis(), 2, this.client.getValues().getPrivateAppointmentFolder(), this.client.getValues().getUserId(), this.client2.getValues().getUserId());
        this.folder = this.ftm.insertFolderOnServer(this.folder);
        this.ctm.setClient(this.client2);
        int nextYear = Calendar.getInstance().get(1) + 1;
        this.app = new Appointment();
        this.app.setTitle("Bug 35687 Test");
        this.app.setStartDate(TimeTools.D("16.12." + nextYear + " 08:00"));
        this.app.setEndDate(TimeTools.D("16.12." + nextYear + " 09:00"));
        this.app.setParentFolderID(this.folder.getObjectID());
        this.app.setAlarm(15);
        this.app.setIgnoreConflicts(true);
        this.app = this.ctm.insert(this.app);
        System.out.println("hello");
    }

    public void testBug35687() throws Exception {
        Appointment loaded = this.ctm.get(this.app);
        Bug35687Test.assertEquals((String)"Wrong alarm value", (int)15, (int)loaded.getAlarm());
        List<Appointment> listAppointment = this.ctm.list(new ListIDs(this.folder.getObjectID(), this.app.getObjectID()), new int[]{204});
        Bug35687Test.assertTrue((String)"Missing alarm value for list request.", (boolean)listAppointment.get(0).containsAlarm());
        Bug35687Test.assertEquals((String)"Wrong alarm value for list request.", (int)15, (int)listAppointment.get(0).getAlarm());
    }

    @Override
    public void tearDown() throws Exception {
        this.ctm.cleanUp();
        this.ftm.cleanUp();
        super.tearDown();
    }
}

