/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.ConflictObject;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Calendar;
import java.util.List;

public class Bug31810Test
extends AbstractAJAXSession {
    private CalendarTestManager ctm;
    private int nextYear;
    private Appointment single;
    private Appointment conflict;

    public Bug31810Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.nextYear = Calendar.getInstance().get(1) + 1;
        this.single = new Appointment();
        this.single.setTitle("Bug 31810 appointment.");
        this.single.setStartDate(TimeTools.D("03.03." + this.nextYear + " 08:00"));
        this.single.setEndDate(TimeTools.D("03.03." + this.nextYear + " 09:00"));
        this.single.setIgnoreConflicts(true);
        this.single.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.single);
        this.conflict = new Appointment();
        this.conflict.setTitle("Bug 31810 appointment.");
        this.conflict.setStartDate(TimeTools.D("03.03." + this.nextYear + " 08:00"));
        this.conflict.setEndDate(TimeTools.D("03.03." + this.nextYear + " 09:00"));
        this.conflict.setIgnoreConflicts(false);
        this.conflict.setShownAs(4);
        this.conflict.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.ctm.insert(this.conflict);
    }

    public void testBug31810() throws Exception {
        this.conflict.setFullTime(true);
        this.conflict.removeShownAs();
        this.ctm.update(this.conflict);
        List<ConflictObject> conflicts = this.ctm.getLastResponse().getConflicts();
        Bug31810Test.assertFalse((String)"No conflict expected.", (conflicts != null && conflicts.size() > 1 ? 1 : 0) != 0);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

