/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.UserParticipant;
import java.util.ArrayList;

public class Bug21620Test
extends AbstractAJAXSession {
    private Appointment appointment;
    private AJAXClient clientA;
    private AJAXClient clientB;
    private AJAXClient clientC;

    public Bug21620Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clientA = this.getClient();
        this.clientB = new AJAXClient(AJAXClient.User.User2);
        this.clientC = new AJAXClient(AJAXClient.User.User3);
        ArrayList<UserParticipant> users = new ArrayList<UserParticipant>();
        UserParticipant userB = new UserParticipant(this.clientB.getValues().getUserId());
        userB.setConfirm(1);
        users.add(userB);
        ArrayList<UserParticipant> participants = new ArrayList<UserParticipant>();
        UserParticipant participantB = new UserParticipant(this.clientB.getValues().getUserId());
        UserParticipant participantC = new UserParticipant(this.clientC.getValues().getUserId());
        participants.add(participantB);
        participants.add(participantC);
        this.appointment = new Appointment();
        this.appointment.setParentFolderID(this.clientA.getValues().getPrivateAppointmentFolder());
        this.appointment.setIgnoreConflicts(true);
        this.appointment.setTitle("Bug 21620");
        this.appointment.setStartDate(TimeTools.D("14.04.2012 04:00"));
        this.appointment.setEndDate(TimeTools.D("14.04.2012 04:30"));
        this.appointment.setUid("040000008200e00074c5b7101a82e00800000000f023f7ac3313cd01000000000000000010000000ae46597c7c3cd64c9ed652087a48887d");
        this.appointment.setNumberOfAttachments(0);
        this.appointment.setModifiedBy(this.clientA.getValues().getUserId());
        this.appointment.setCreatedBy(this.clientA.getValues().getUserId());
        this.appointment.setFullTime(false);
        this.appointment.setPrivateFlag(false);
        this.appointment.setTimezone("Europe/Berlin");
        this.appointment.setOrganizer(this.clientA.getValues().getDefaultAddress());
        this.appointment.setOrganizerId(this.clientA.getValues().getUserId());
        this.appointment.setPrincipal(this.clientB.getValues().getDefaultAddress());
        this.appointment.setPrincipalId(this.clientB.getValues().getUserId());
        this.appointment.setUsers(users);
        this.appointment.setParticipants(participants);
    }

    public void testBug21620() throws Exception {
        InsertRequest insertRequest = new InsertRequest(this.appointment, this.clientA.getValues().getTimeZone());
        AppointmentInsertResponse insertResponse = this.clientA.execute(insertRequest);
        insertResponse.fillObject((DataObject)this.appointment);
        GetRequest getRequest = new GetRequest(this.appointment);
        GetResponse getResponse = this.clientA.execute(getRequest);
        Appointment loadedAppointment = getResponse.getAppointment(this.clientA.getValues().getTimeZone());
        Bug21620Test.assertEquals((String)"Wrong organizer ID", (int)this.clientA.getValues().getUserId(), (int)loadedAppointment.getOrganizerId());
    }

    @Override
    public void tearDown() throws Exception {
        this.getClient().execute(new DeleteRequest(this.appointment));
        super.tearDown();
    }
}

