/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.UpdateParser;
import com.openexchange.ajax.appointment.action.UpdateResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.groupware.container.Appointment;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateRequest
extends AbstractAppointmentRequest<UpdateResponse> {
    private final Appointment appointmentObj;
    private final TimeZone timeZone;
    private final boolean failOnError;
    private final int originFolder;

    public UpdateRequest(Appointment appointment, TimeZone timeZone) {
        this(appointment, timeZone, true);
    }

    public UpdateRequest(Appointment appointment, TimeZone timezone, boolean failOnError) {
        this(appointment.getParentFolderID(), appointment, timezone, failOnError);
    }

    public UpdateRequest(int originFolder, Appointment appointment, TimeZone timezone, boolean failOnError) {
        this.appointmentObj = appointment;
        this.timeZone = timezone;
        this.failOnError = failOnError;
        this.originFolder = originFolder;
    }

    public JSONObject getBody() throws JSONException {
        return this.convert(this.appointmentObj, this.timeZone);
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        return new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("action", "update"), new AJAXRequest.Parameter("folder", String.valueOf(this.originFolder)), new AJAXRequest.Parameter("id", String.valueOf(this.appointmentObj.getObjectID())), new AJAXRequest.Parameter("timestamp", String.valueOf(this.appointmentObj.getLastModified().getTime()))};
    }

    public UpdateParser getParser() {
        return new UpdateParser(this.failOnError);
    }

    protected Appointment getAppointment() {
        return this.appointmentObj;
    }
}

