/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.ConfirmParser;
import com.openexchange.ajax.appointment.action.ConfirmResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import java.util.ArrayList;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfirmRequest
extends AbstractAppointmentRequest<ConfirmResponse> {
    private final int folderId;
    private final int objectId;
    private final int confirmStatus;
    private final String confirmMessage;
    private int user;
    private final boolean failOnError;
    private String mail;
    private final int type;
    private int occurrence;
    private Date lastModified;

    public ConfirmRequest(int folderId, int objectId, int occurrence, int confirmStatus, String confirmMessage, String mail, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.objectId = objectId;
        this.occurrence = occurrence;
        this.confirmStatus = confirmStatus;
        this.confirmMessage = confirmMessage;
        this.mail = mail;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
        this.type = 5;
    }

    public ConfirmRequest(int folderId, int objectId, int confirmStatus, String confirmMessage, String mail, Date lastModified, boolean failOnError) {
        this(folderId, objectId, 0, confirmStatus, confirmMessage, mail, lastModified, failOnError);
    }

    public ConfirmRequest(int folderId, int objectId, int occurrence, int confirmStatus, String confirmMessage, int user, Date lastModified, boolean failOnError) {
        this.folderId = folderId;
        this.objectId = objectId;
        this.occurrence = occurrence;
        this.confirmStatus = confirmStatus;
        this.confirmMessage = confirmMessage;
        this.user = user;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
        this.type = 1;
    }

    public ConfirmRequest(int folderId, int objectId, int confirmStatus, String confirmMessage, int user, Date lastModified, boolean failOnError) {
        this(folderId, objectId, 0, confirmStatus, confirmMessage, user, lastModified, failOnError);
    }

    public ConfirmRequest(int folderId, int objectId, int confirmStatus, String confirmMessage, Date lastModified, boolean failOnError) {
        this(folderId, objectId, confirmStatus, confirmMessage, 0, lastModified, failOnError);
    }

    @Override
    public Object getBody() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("confirmmessage", (Object)this.confirmMessage);
        json.put("confirmation", this.confirmStatus);
        json.put("type", this.type);
        if (this.user != 0) {
            json.put("id", this.user);
        }
        if (this.mail != null) {
            json.put("mail", (Object)this.mail);
        }
        return json;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> parameterList = new ArrayList<AJAXRequest.Parameter>();
        parameterList.add(new AJAXRequest.Parameter("action", "confirm"));
        parameterList.add(new AJAXRequest.Parameter("id", this.objectId));
        parameterList.add(new AJAXRequest.Parameter("folder", this.folderId));
        parameterList.add(new AJAXRequest.Parameter("timestamp", this.lastModified));
        if (this.occurrence > 0) {
            parameterList.add(new AJAXRequest.Parameter("occurrence", this.occurrence));
        }
        return parameterList.toArray(new AJAXRequest.Parameter[parameterList.size()]);
    }

    @Override
    public AbstractAJAXParser<? extends ConfirmResponse> getParser() {
        return new ConfirmParser(this.failOnError);
    }
}

