/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AllParser;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonAllRequest;
import com.openexchange.calendar.json.actions.AppointmentAction;
import com.openexchange.groupware.search.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.TimeZone;

public class AllRequest
extends CommonAllRequest {
    public static final int[] GUI_COLUMNS = new int[]{1, 20};
    public static final int GUI_SORT = 201;
    public static final Order GUI_ORDER = Order.ASCENDING;
    private final Date start;
    private final Date end;
    private final boolean recurrenceMaster;
    private String timeZoneId;
    private final boolean showPrivates;

    public AllRequest(int folderId, int[] columns, Date start, Date end, TimeZone tz) {
        this(folderId, columns, start, end, tz, true);
    }

    public AllRequest(int folderId, int[] columns, Date start, Date end, TimeZone tz, boolean recurrenceMaster) {
        this(folderId, columns, start, end, tz, recurrenceMaster, false);
    }

    public AllRequest(int folderId, int[] columns, Date start, Date end, TimeZone tz, boolean recurrenceMaster, boolean showPrivates) {
        super("/ajax/calendar", folderId, AllRequest.addGUIColumns(columns), 0, null, true);
        this.start = AllRequest.addTimeZone2Date(start, tz);
        this.end = AllRequest.addTimeZone2Date(end, tz);
        this.recurrenceMaster = recurrenceMaster;
        this.showPrivates = showPrivates;
    }

    public AllRequest(int folderId, String alias, Date start, Date end, TimeZone tz) {
        this(folderId, alias, start, end, tz, true);
    }

    public AllRequest(int folderId, String alias, Date start, Date end, TimeZone tz, boolean recurrenceMaster) {
        this(folderId, alias, start, end, tz, recurrenceMaster, false);
    }

    public AllRequest(int folderId, String alias, Date start, Date end, TimeZone tz, boolean recurrenceMaster, boolean showPrivates) {
        super("/ajax/calendar", folderId, alias, 0, null, true);
        this.start = AllRequest.addTimeZone2Date(start, tz);
        this.end = AllRequest.addTimeZone2Date(end, tz);
        this.recurrenceMaster = recurrenceMaster;
        this.showPrivates = showPrivates;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.timeZoneId = timeZoneId;
    }

    private static int[] addGUIColumns(int[] columns) {
        int i;
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < columns.length; ++i) {
            list.add(columns[i]);
        }
        for (i = 0; i < GUI_COLUMNS.length; ++i) {
            Integer column = GUI_COLUMNS[i];
            if (list.contains(column)) continue;
            list.add(column);
        }
        int[] retval = new int[list.size()];
        for (int i2 = 0; i2 < retval.length; ++i2) {
            retval[i2] = (Integer)list.get(i2);
        }
        return retval;
    }

    private static Date addTimeZone2Date(Date d, TimeZone tz) {
        return AllRequest.addTimeZone2Date(d.getTime(), tz);
    }

    private static Date addTimeZone2Date(long timeMillis, TimeZone tz) {
        return new Date(timeMillis + (long)tz.getOffset(timeMillis));
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        LinkedList<AJAXRequest.Parameter> params = new LinkedList<AJAXRequest.Parameter>(Arrays.asList(super.getParameters()));
        if (null != this.timeZoneId) {
            params.add(new AJAXRequest.Parameter("timezone", this.timeZoneId));
        }
        params.add(new AJAXRequest.Parameter("start", this.start));
        params.add(new AJAXRequest.Parameter("end", this.end));
        params.add(new AJAXRequest.Parameter("recurrence_master", this.recurrenceMaster));
        params.add(new AJAXRequest.Parameter("showPrivate", this.showPrivates));
        return params.toArray(new AJAXRequest.Parameter[0]);
    }

    @Override
    public AllParser getParser() {
        if (this.getColumns() != null) {
            return new AllParser(this.isFailOnError(), this.getColumns());
        }
        if (this.getAlias().equals("all")) {
            return new AllParser(this.isFailOnError(), AppointmentAction.COLUMNS_ALL_ALIAS);
        }
        if (this.getAlias().equals("list")) {
            return new AllParser(this.isFailOnError(), AppointmentAction.COLUMNS_LIST_ALIAS);
        }
        return null;
    }
}

