/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.AppointmentTest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.configuration.AbstractConfigWrapper;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.webdav.xml.FolderTest;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveTest
extends AppointmentTest {
    private static final Logger LOG = LoggerFactory.getLogger(MoveTest.class);
    private String login;
    private String password;
    private String context;
    private int targetFolder;
    private int objectId;

    public MoveTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.login = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"login", (String)"");
        this.context = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"contextName", (String)"defaultcontext");
        this.password = AbstractConfigWrapper.parseProperty((Properties)this.getAJAXProperties(), (String)"password", (String)"");
        this.targetFolder = 0;
    }

    @Override
    protected void tearDown() throws Exception {
        if (0 != this.objectId) {
            MoveTest.deleteAppointment(this.getWebConversation(), this.objectId, this.targetFolder, "http://" + this.getHostName(), this.getSessionId(), false);
        }
        if (0 != this.targetFolder) {
            FolderTest.deleteFolder(this.getWebConversation(), new int[]{this.targetFolder}, "http://" + this.getHostName(), this.login, this.password, this.context);
        }
        super.tearDown();
    }

    public void testMove2PrivateFolder() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testMove2PrivateFolder" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setShownAs(1);
        this.objectId = MoveTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testMove2PrivateFolder" + System.currentTimeMillis(), 2, false);
        this.targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj.setParentFolderID(this.targetFolder);
        MoveTest.updateAppointment(this.getWebConversation(), appointmentObj, this.objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = MoveTest.loadAppointment(this.getWebConversation(), this.objectId, this.targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(this.objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
    }

    public void testMove2PublicFolder() throws Exception {
        Appointment appointmentObj = new Appointment();
        String date = String.valueOf(System.currentTimeMillis());
        appointmentObj.setTitle("testMove2PublicFolder" + date);
        appointmentObj.setStartDate(new Date(startTime));
        appointmentObj.setEndDate(new Date(endTime));
        appointmentObj.setOrganizer(AJAXClient.User.User1.name());
        appointmentObj.setParentFolderID(appointmentFolderId);
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setShownAs(1);
        this.objectId = MoveTest.insertAppointment(this.getWebConversation(), appointmentObj, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        FolderObject folderObj = FolderTest.createFolderObject(this.userId, "testMove2PublicFolder" + System.currentTimeMillis(), 2, true);
        this.targetFolder = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.login, this.password, this.context);
        appointmentObj.setParentFolderID(this.targetFolder);
        MoveTest.updateAppointment(this.getWebConversation(), appointmentObj, this.objectId, appointmentFolderId, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        Appointment loadAppointment = MoveTest.loadAppointment(this.getWebConversation(), this.objectId, this.targetFolder, this.timeZone, "http://" + this.getHostName(), this.getSessionId());
        appointmentObj.setObjectID(this.objectId);
        this.compareObject(appointmentObj, loadAppointment, appointmentObj.getStartDate().getTime(), appointmentObj.getEndDate().getTime());
    }
}

