/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment;

import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.calendar.TimeTools;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.test.CalendarTestManager;
import java.util.Date;
import java.util.TimeZone;

public class ChangeTimeZoneTest
extends AbstractAJAXSession {
    private final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private final TimeZone BERLIN = TimeZone.getTimeZone("Europe/Berlin");
    private final TimeZone US = TimeZone.getTimeZone("US/Eastern");
    private CalendarTestManager ctm;
    private Appointment app;

    public ChangeTimeZoneTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.ctm = new CalendarTestManager(this.client);
        this.app = new Appointment();
        this.app.setTitle("ChangeTimeZoneTest");
        this.app.setParentFolderID(this.client.getValues().getPrivateAppointmentFolder());
        this.app.setStartDate(TimeTools.D("01.04.2015 08:00", this.UTC));
        this.app.setEndDate(TimeTools.D("01.04.2015 09:00", this.UTC));
        this.app.setTimezone("Europe/Berlin");
        this.ctm.insert(this.app);
    }

    public void testSimpleTimeZoneChange() throws Exception {
        this.app.setLastModified(new Date(Long.MAX_VALUE));
        this.app.setTimezone("US/Eastern");
        this.ctm.update(this.app);
        Appointment loaded = this.ctm.get(this.client.getValues().getPrivateAppointmentFolder(), this.app.getObjectID());
        ChangeTimeZoneTest.assertEquals((String)"Wrong tmezone.", (String)"US/Eastern", (String)loaded.getTimezone());
        ChangeTimeZoneTest.assertTrue((boolean)true);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }
}

