/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.PutMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.cookies.CookieJar;
import com.openexchange.ajax.AbstractAJAXTest;
import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.container.Response;
import com.openexchange.java.Charsets;
import com.openexchange.tools.URLParameter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.activation.MimetypesFileTypeMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public class MailTest
extends AbstractAJAXTest {
    private String sessionId = null;
    private static final String MAIL_URL = "/ajax/mail";
    private static final StringBuilder FILE_CONTENT_BUILDER = new StringBuilder();
    private static final SimpleDateFormat SDF;
    private static final String MAILTEXT = "This is mail text!<br>Next line<br/><br/>best regards,<br>Max Mustermann";

    public MailTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.sessionId = this.getSessionId();
    }

    @Override
    public void tearDown() throws Exception {
        this.logout();
    }

    public static File createTempFile() {
        try {
            File tmpFile = File.createTempFile("file_", ".txt");
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(tmpFile)));
            BufferedReader reader = new BufferedReader(new StringReader(FILE_CONTENT_BUILDER.toString()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                writer.write(line + "\r\n");
            }
            reader.close();
            writer.flush();
            writer.close();
            tmpFile.deleteOnExit();
            return tmpFile;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static JSONObject sendMail(WebConversation conversation, String hostname, String sessionId, JSONObject mailObj, File[] uploadFileAttachments, boolean setCookie) throws Exception {
        return MailTest.sendMail(conversation, hostname, sessionId, mailObj.toString(), uploadFileAttachments, setCookie);
    }

    public static JSONObject sendMail(WebConversation conversation, String hostname, String sessionId, String mailObjStr, File[] uploadFileAttachments, boolean setCookie) throws Exception {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "new");
        PostMethodWebRequest req = null;
        WebResponse resp = null;
        if (setCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        PostMethodWebRequest postReq = new PostMethodWebRequest(hostname + MAIL_URL + parameter.getURLParameters(), true);
        postReq.setParameter("json_0", mailObjStr);
        JSONObject jResponse = null;
        if (uploadFileAttachments != null) {
            for (int i = 0; i < uploadFileAttachments.length; ++i) {
                File f = uploadFileAttachments[i];
                postReq.selectFile("file_" + i, f, MailTest.getFileContentType(f));
            }
        }
        req = postReq;
        resp = conversation.getResource((WebRequest)req);
        jResponse = MailTest.extractFromCallback(resp.getText());
        return jResponse;
    }

    public static JSONObject forwardMail(WebConversation conversation, String hostname, String sessionId, JSONObject mailObj, String msgRef, File[] uploadFileAttachments) throws Exception {
        if (!mailObj.has("msgRef") || mailObj.isNull("msgRef")) {
            mailObj.putOpt("msgRef", (Object)msgRef);
        }
        return MailTest.sendMail(conversation, hostname, sessionId, mailObj.toString(), uploadFileAttachments, false);
    }

    public static JSONObject getForwardMailForDisplay(WebConversation conversation, String hostname, String sessionId, String mailIdentifier, boolean addCookie) throws Exception {
        GetMethodWebRequest getReq = new GetMethodWebRequest(hostname + MAIL_URL);
        getReq.setParameter("session", sessionId);
        getReq.setParameter("action", "forward");
        getReq.setParameter("id", mailIdentifier);
        if (addCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        WebResponse resp = conversation.getResponse((WebRequest)getReq);
        JSONObject jResponse = new JSONObject(resp.getText());
        return jResponse;
    }

    public static JSONObject deleteMail(WebConversation conversation, String hostname, String sessionId, String mailIdentifier, boolean addCookie) throws Exception {
        URLParameter parameter = new URLParameter();
        parameter.setParameter("session", sessionId);
        parameter.setParameter("action", "delete");
        byte[] bytes = new StringBuilder(50).append('[').append("{\"id\":\"").append(mailIdentifier).append("\"}").append(']').toString().getBytes(Charsets.UTF_8);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        PutMethodWebRequest putReq = new PutMethodWebRequest(hostname + MAIL_URL + parameter.getURLParameters(), (InputStream)bais, "text/javascript; charset=UTF-8");
        if (addCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        WebResponse resp = conversation.getResponse((WebRequest)putReq);
        JSONObject jResponse = new JSONObject(resp.getText());
        return jResponse;
    }

    public static JSONObject getAllMails(WebConversation conversation, String hostname, String sessionId, String folder, int[] cols, boolean setCookie) throws IOException, SAXException, JSONException {
        return MailTest.getAllMails(conversation, null, hostname, sessionId, folder, cols, setCookie);
    }

    public static JSONObject getAllMails(WebConversation conversation, String protocol, String hostname, String sessionId, String folder, int[] cols, boolean setCookie) throws IOException, SAXException, JSONException {
        String colsStr;
        GetMethodWebRequest getReq = new GetMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostname + MAIL_URL);
        if (setCookie) {
            CookieJar cookieJar = new CookieJar();
            cookieJar.putCookie(LoginServlet.SESSION_PREFIX + sessionId, sessionId);
        }
        getReq.setParameter("session", sessionId);
        getReq.setParameter("action", "all");
        getReq.setParameter("folder", folder);
        if (cols != null && cols.length > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(cols[0]);
            for (int i = 1; i < cols.length; ++i) {
                sb.append(',').append(cols[i]);
            }
            colsStr = sb.toString();
        } else {
            colsStr = "600,601,602,612,603,607,610,608,611,614,102";
        }
        getReq.setParameter("columns", colsStr);
        getReq.setParameter("sort", "610");
        getReq.setParameter("order", "asc");
        WebResponse resp = conversation.getResponse((WebRequest)getReq);
        JSONObject jResponse = new JSONObject(resp.getText());
        return jResponse;
    }

    public static Response getMail(WebConversation conversation, String hostName, String sessionId, String mailId) throws IOException, SAXException, JSONException {
        return MailTest.getMail(conversation, null, hostName, sessionId, mailId);
    }

    public static Response getMail(WebConversation conversation, String protocol, String hostName, String sessionId, String mailId) throws IOException, SAXException, JSONException {
        GetMethodWebRequest getReq = new GetMethodWebRequest((null == protocol ? "http://" : protocol + "://") + hostName + MAIL_URL);
        getReq.setParameter("session", sessionId);
        getReq.setParameter("action", "get");
        getReq.setParameter("id", mailId);
        WebResponse resp = conversation.getResponse((WebRequest)getReq);
        MailTest.assertEquals((String)"Response code is not okay.", (int)200, (int)resp.getResponseCode());
        String body = resp.getText();
        Response response = Response.parse((String)body);
        MailTest.assertFalse((String)response.getErrorMessage(), (boolean)response.hasError());
        return response;
    }

    private static String getFileContentType(File f) {
        return new MimetypesFileTypeMap().getContentType(f);
    }

    public void testFail() {
        try {
            JSONObject jResp = null;
            JSONObject mailObj = new JSONObject();
            JSONArray attachments = new JSONArray();
            JSONObject attach = new JSONObject();
            attach.put("content", (Object)MAILTEXT);
            attach.put("content_type", (Object)"text/plain");
            attachments.put((Object)attach);
            mailObj.put("attachments", (Object)attachments);
            jResp = MailTest.sendMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, null, false);
            MailTest.assertTrue((jResp == null || jResp.has("error") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            MailTest.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendSimpleMail() throws IOException, SAXException, Exception {
        JSONObject jResp = null;
        try {
            JSONObject mailObj = new JSONObject();
            mailObj.put("from", (Object)this.getSeconduser());
            mailObj.put("to", (Object)this.getLogin());
            mailObj.put("subject", (Object)("JUnit Test Mail: " + SDF.format(new Date())));
            JSONArray attachments = new JSONArray();
            JSONObject attach = new JSONObject();
            attach.put("content", (Object)MAILTEXT);
            attach.put("content_type", (Object)"text/plain");
            attachments.put((Object)attach);
            mailObj.put("attachments", (Object)attachments);
            jResp = MailTest.sendMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, null, false);
            MailTest.assertTrue((jResp != null ? 1 : 0) != 0);
        }
        finally {
            if (jResp != null && jResp.has("data") && !jResp.isNull("data")) {
                String mailIdentifer = jResp.getString("data");
                try {
                    MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
                }
                catch (Exception e) {
                    System.err.println("Test-Mail \"" + mailIdentifer + "\" could NOT be deleted!");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSendMailWithMultipleAttachment() throws IOException, SAXException, JSONException, Exception {
        JSONObject jResp = null;
        try {
            JSONObject mailObj = new JSONObject();
            mailObj.put("from", (Object)this.getSeconduser());
            mailObj.put("to", (Object)this.getLogin());
            mailObj.put("subject", (Object)("JUnit Test Mail with an attachment: " + SDF.format(new Date())));
            JSONArray attachments = new JSONArray();
            JSONObject attach = new JSONObject();
            attach.put("content", (Object)"Mail text");
            attach.put("content_type", (Object)"text/plain");
            attachments.put((Object)attach);
            mailObj.put("attachments", (Object)attachments);
            File[] fa = new File[]{MailTest.createTempFile(), MailTest.createTempFile(), MailTest.createTempFile()};
            jResp = MailTest.sendMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, fa, false);
            MailTest.assertTrue((jResp != null ? 1 : 0) != 0);
        }
        finally {
            if (jResp != null && jResp.has("data") && !jResp.isNull("data")) {
                String mailIdentifer = jResp.getString("data");
                MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testForwardMail() throws IOException, SAXException, JSONException, Exception {
        JSONObject jResp = null;
        String mailIdentifer = null;
        try {
            JSONObject mailObj = new JSONObject();
            mailObj.put("from", (Object)this.getSeconduser());
            mailObj.put("to", (Object)this.getLogin());
            mailObj.put("subject", (Object)("JUnit Test Mail with an attachment: " + SDF.format(new Date())));
            JSONArray attachments = new JSONArray();
            JSONObject attach = new JSONObject();
            attach.put("content", (Object)"Mail text");
            attach.put("content_type", (Object)"text/plain");
            attachments.put((Object)attach);
            mailObj.put("attachments", (Object)attachments);
            File[] fa = new File[]{MailTest.createTempFile(), MailTest.createTempFile(), MailTest.createTempFile()};
            jResp = MailTest.sendMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, fa, false);
            mailIdentifer = jResp.getString("data");
            jResp = MailTest.getForwardMailForDisplay(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
            MailTest.assertTrue((jResp != null ? 1 : 0) != 0);
            if (mailIdentifer == null) return;
        }
        catch (Throwable throwable) {
            if (mailIdentifer == null) throw throwable;
            MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
            throw throwable;
        }
        MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testSendForwardMailWithAttachments() throws IOException, SAXException, JSONException, Exception {
        JSONObject jResp = null;
        String mailIdentifer = null;
        try {
            JSONObject mailObj = new JSONObject();
            mailObj.put("from", (Object)this.getSeconduser());
            mailObj.put("to", (Object)this.getLogin());
            mailObj.put("subject", (Object)("JUnit ForwardMe Mail with an attachment: " + SDF.format(new Date())));
            JSONArray attachments = new JSONArray();
            JSONObject attach = new JSONObject();
            attach.put("content", (Object)"Mail text");
            attach.put("content_type", (Object)"text/plain");
            attachments.put((Object)attach);
            mailObj.put("attachments", (Object)attachments);
            File[] fa = new File[]{MailTest.createTempFile(), MailTest.createTempFile(), MailTest.createTempFile()};
            jResp = MailTest.sendMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, fa, false);
            mailIdentifer = jResp.getString("data");
            mailObj.put("subject", (Object)("Fwd: JUnit ForwardMe Mail with an attachment: " + SDF.format(new Date())));
            fa = new File[]{MailTest.createTempFile()};
            jResp = MailTest.forwardMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailObj, mailIdentifer, fa);
            MailTest.assertTrue((jResp != null ? 1 : 0) != 0);
            if (mailIdentifer == null) return;
        }
        catch (Throwable throwable) {
            if (mailIdentifer == null) throw throwable;
            MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
            throw throwable;
        }
        MailTest.deleteMail(this.getWebConversation(), "http://" + this.getHostName(), this.getSessionId(), mailIdentifer, true);
    }

    public void testNewMailsInInbox() {
        MailTest.assertTrue((boolean)true);
    }

    public void testGetMails() throws IOException, SAXException, JSONException, Exception {
        JSONObject jResp = null;
        JSONObject mailObj = new JSONObject();
        mailObj.put("from", (Object)this.getSeconduser());
        mailObj.put("to", (Object)this.getLogin());
        mailObj.put("subject", (Object)("JUnit testGetMails Test Mail: " + SDF.format(new Date())));
        JSONArray attachments = new JSONArray();
        JSONObject attach = new JSONObject();
        attach.put("content", (Object)MAILTEXT);
        attach.put("content_type", (Object)"text/plain");
        attachments.put((Object)attach);
        mailObj.put("attachments", (Object)attachments);
        WebConversation conversation = this.getWebConversation();
        jResp = MailTest.sendMail(conversation, "http://" + this.getHostName(), this.getSessionId(), mailObj, null, false);
        MailTest.assertFalse((boolean)jResp.has("error"));
        for (int i = 2; i <= 10; ++i) {
            jResp = MailTest.sendMail(conversation, "http://" + this.getHostName(), this.getSessionId(), mailObj, null, true);
            MailTest.assertFalse((boolean)jResp.has("error"));
        }
        jResp = MailTest.getAllMails(conversation, this.getHostName(), this.getSessionId(), "INBOX", null, true);
        MailTest.assertTrue((jResp != null ? 1 : 0) != 0);
    }

    public void testGetMsgSrc() throws IOException, SAXException, JSONException, Exception {
        JSONObject jResp = null;
        JSONObject mailObj = new JSONObject();
        mailObj.put("from", (Object)this.getSeconduser());
        mailObj.put("to", (Object)this.getLogin());
        mailObj.put("subject", (Object)("JUnit Source Test Mail: " + SDF.format(new Date())));
        JSONArray attachments = new JSONArray();
        JSONObject attach = new JSONObject();
        attach.put("content", (Object)MAILTEXT);
        attach.put("content_type", (Object)"text/plain");
        attachments.put((Object)attach);
        mailObj.put("attachments", (Object)attachments);
        WebConversation conversation = this.getWebConversation();
        jResp = MailTest.sendMail(conversation, "http://" + this.getHostName(), this.getSessionId(), mailObj, null, false);
        MailTest.assertFalse((boolean)jResp.has("error"));
        String mailidentifier = jResp.getString("data");
        GetMethodWebRequest getReq = new GetMethodWebRequest("http://" + this.getHostName() + MAIL_URL);
        CookieJar cookieJar = new CookieJar();
        cookieJar.putCookie(LoginServlet.SESSION_PREFIX + this.getSessionId(), this.getSessionId());
        getReq.setParameter("session", this.getSessionId());
        getReq.setParameter("action", "get");
        getReq.setParameter("id", mailidentifier);
        getReq.setParameter("src", "true");
        WebResponse resp = conversation.getResponse((WebRequest)getReq);
        jResp = new JSONObject(resp.getText());
        MailTest.assertFalse((boolean)jResp.has("error"));
    }

    public void testReplyMail() {
        MailTest.assertTrue((boolean)true);
    }

    static {
        FILE_CONTENT_BUILDER.append("First line of text file").append("\r\n");
        FILE_CONTENT_BUILDER.append("Second line of text file").append("\r\n");
        FILE_CONTENT_BUILDER.append("Third line of text file").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        FILE_CONTENT_BUILDER.append("Blah blah blah blah blah blah blah blah bah blah foobar").append("\r\n");
        SDF = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss", Locale.GERMAN);
    }
}

