/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FetchProfile {
    private final List<Item> specials = new LinkedList<Item>();
    private final Set<String> headers = new LinkedHashSet<String>();

    public void add(Item item) {
        if (!this.specials.contains(item)) {
            this.specials.add(item);
        }
    }

    public void add(String headerName) {
        this.headers.add(headerName);
    }

    public boolean contains(Item item) {
        return this.specials.contains(item);
    }

    public boolean contains(String headerName) {
        return this.headers.contains(headerName);
    }

    public Item[] getItems() {
        return this.specials.isEmpty() ? new Item[]{} : this.specials.toArray(new Item[this.specials.size()]);
    }

    public String[] getHeaderNames() {
        return this.headers.isEmpty() ? new String[]{} : this.headers.toArray(new String[this.headers.size()]);
    }

    public static class Item {
        public static final Item ENVELOPE = new Item("ENVELOPE");
        public static final Item CONTENT_INFO = new Item("CONTENT_INFO");
        public static final Item SIZE = new Item("SIZE");
        public static final Item FLAGS = new Item("FLAGS");
        private final String name;

        protected Item(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.name + "]";
        }
    }
}

